/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.util;

import chumbanotz.abyssaldepths.util.Euler;
import javax.annotation.Nullable;
import net.minecraft.util.math.vector.Vector3d;

public class Bone {
    private float length = 1.0f;
    private final Euler angle = new Euler();
    @Nullable
    private final Bone parent;

    public Bone() {
        this(null);
    }

    public Bone(@Nullable Bone parentNode) {
        this.parent = parentNode;
    }

    public void setLength(float length) {
        this.length = length;
    }

    public float getLength() {
        return this.length;
    }

    public void setRotation(float pitch, float yaw, float roll) {
        this.angle.setAngles(pitch, yaw, roll);
    }

    public void setRotation(Euler euler) {
        this.angle.setAngles(euler);
    }

    public Euler getRotation() {
        return this.angle;
    }

    @Nullable
    public Bone getParent() {
        return this.parent;
    }

    public Euler getAbsoluteRotation() {
        return this.parent != null ? this.angle.getRotated(this.parent.getAbsoluteRotation()) : new Euler(this.angle);
    }

    public Vector3d getRotatedVector() {
        return this.angle.rotateVector(this.length);
    }

    public Vector3d getAbsoluteRotatedVector() {
        return this.getAbsoluteRotation().rotateVector(this.length);
    }

    public Vector3d getTotalRotatedVector() {
        if (this.parent != null) {
            Vector3d totalVec = this.parent.getTotalRotatedVector();
            Vector3d absVec = this.getAbsoluteRotatedVector();
            return totalVec.func_178787_e(absVec);
        }
        return this.getRotatedVector();
    }
}

