/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.minecraft.forge.client.renderer.GlassMeterRenderer;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Objects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Indicator {
    private final ColorARGB color;
    private final TargetLocation location;

    public Indicator(ColorARGB color, TargetLocation location) {
        this.color = color;
        this.location = location;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public TargetLocation getTargetLocation() {
        return this.location;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addVertex(IVertexBuilder vertexBuilder, MatrixStack matrix, float x, float y, float u, float v) {
        GlassMeterRenderer.addVertex((IVertexBuilder)vertexBuilder, (MatrixStack)matrix, (ColorARGB)this.getColor(), (float)x, (float)y, (float)u, (float)v);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Indicator) {
            Indicator indicator = (Indicator)obj;
            return indicator.getColor().equals((Object)this.getColor()) && indicator.getTargetLocation().equals(this.getTargetLocation());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getColor(), this.getTargetLocation());
    }
}

