/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adfinders.finder.Indicator;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Comparator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Needle
extends Indicator {
    private static final float WIDTH = 0.1f;
    private static final float LENGTH = 0.35f;
    public static final float OFFSET = 0.001f;
    public static final Comparator<Needle> SORTING_COMPARATOR = (t1, t2) -> t1.equals(t2) ? 0 : -Double.compare(t1.getTargetLocation().getDistance(), t2.getTargetLocation().getDistance());

    public Needle(ColorARGB color, TargetLocation location) {
        super(color, location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(IVertexBuilder builder, MatrixStack matrix, CommonMath.Angle angle, float scale) {
        matrix.func_227860_a_();
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_((float)angle.getRadians()));
        float sW = 0.05f * scale;
        float sL = 0.35f * scale;
        this.addVertex(builder, matrix, -sW, -sL / 5.0f, 0.0f, 0.0f);
        this.addVertex(builder, matrix, sW, -sL / 5.0f, 1.0f, 0.0f);
        this.addVertex(builder, matrix, sW, sL, 1.0f, 1.0f);
        this.addVertex(builder, matrix, -sW, sL, 0.0f, 1.0f);
        matrix.func_227865_b_();
    }

    public CommonMath.Angle getAngle(Vect3d startPos, float rotationYaw) {
        Vect3d targetPos = GameWorld.getBlockCenter((BlockPos)this.getTargetLocation().getPos());
        Vect3d delta = startPos.subtract(targetPos);
        return CommonMath.Angle.fromDegrees((double)(rotationYaw - 90.0f - GameMath.arcTan((double)delta.z, (double)delta.x)));
    }
}

