/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.client.renderer.GlassMeterRenderer;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adfinders.finder.Arrows;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Needle;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Renderer
extends GlassMeterRenderer {
    protected void renderIndicators(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer) {
        FinderState state = Finder.findStateFor(stack).orElse(null);
        if (state == null) {
            return;
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227861_a_(0.0, 0.0, (double)-0.04f);
        Entity carrier = state.getCarrier();
        Vect3d startPos = ForgeEntity.getCenterPosition((Entity)carrier);
        float rotationYaw = carrier.field_70177_z;
        if (carrier instanceof LivingEntity) {
            Minecraft mc = Minecraft.func_71410_x();
            if (carrier != mc.field_71439_g || mc.field_71474_y.func_243230_g() != PointOfView.FIRST_PERSON) {
                rotationYaw = ((LivingEntity)carrier).field_70761_aq;
            }
        }
        IVertexBuilder builder = buffer.getBuffer(RENDER_TYPE);
        float offset = 0.0f;
        for (Arrows.Arrow arrow : state.getArrows().values()) {
            if (arrow == null) continue;
            matrix.func_227861_a_(0.0, 0.0, (double)offset);
            arrow.draw(builder, matrix, 1.0f);
            matrix.func_227861_a_(0.0, 0.0, (double)(-offset));
        }
        offset = 0.001f;
        matrix.func_227861_a_(0.0, 0.0, (double)offset);
        for (Needle needle : state.getNeedles()) {
            CommonMath.Angle angle = needle.getAngle(startPos, rotationYaw);
            matrix.func_227861_a_(0.0, 0.0, (double)offset);
            needle.draw(builder, matrix, angle, 1.0f);
            matrix.func_227861_a_(0.0, 0.0, (double)(-offset));
            offset += 0.001f;
        }
        matrix.func_227865_b_();
    }
}

