/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.init;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adfinders.AdFinders;
import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import java.nio.file.Path;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public enum FinderType implements IForgeEnum
{
    GEM(6, 32, 2, TextFormatting.DARK_AQUA),
    METAL(8, 48, 3, TextFormatting.GOLD),
    MINERAL(7, 40, 4, TextFormatting.DARK_PURPLE);

    public final Finder finder;
    public final Definitions definitions;

    private FinderType(int scanRange, int pingRange, int veinMinSize, TextFormatting textFormatting) {
        UnitConfig config = UnitConfig.in((Path)AdFinders.getInstance().getConfigsDir(), (String)"Finders", (String)this.getName());
        this.finder = new Finder(AdFinders.getInstance(), config, this.getName() + "_finder", scanRange, pingRange, veinMinSize, veinMinSize * 8, textFormatting);
        this.definitions = new Definitions(this.finder.getUnitCategory());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.func_130014_f_();
        if (GameWorld.isServerSide((IWorldReader)world) && player instanceof ServerPlayerEntity) {
            for (FinderType finder : FinderType.values()) {
                Finder.SyncClientMsg message = new Finder.SyncClientMsg(finder);
                AdFinders.getInstance().getConnection().sendToPlayer((Object)message, (ServerPlayerEntity)player);
            }
        }
    }
}

