/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.block.BlockBaseAutomation;
import net.shadowmage.ancientwarfare.automation.gui.GuiWarehouseStockLinker;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStockLinker;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class BlockWarehouseStockLinker
extends BlockBaseAutomation
implements BlockRotationHandler.IRotatableBlock {
    private static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    private static final Map<EnumFacing, AxisAlignedBB> AABBS;
    public final List<TileWarehouseStockLinker.WarehouseStockFilter> filters = new ArrayList<TileWarehouseStockLinker.WarehouseStockFilter>();

    public BlockWarehouseStockLinker(String regName) {
        super(Material.field_151576_e, regName);
        this.func_149711_c(2.0f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileWarehouseStockLinker();
    }

    public boolean func_149744_f(IBlockState iBlockState) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.isPowered(blockAccess, pos) ? 15 : 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        boolean doPower = this.isPowered(world, pos);
        if (!doPower) {
            return 0;
        }
        return state.func_177229_b((IProperty)CoreProperties.FACING) == side ? 15 : 0;
    }

    private boolean isPowered(IBlockAccess world, BlockPos pos) {
        boolean doPower = false;
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileWarehouseStockLinker) {
            TileWarehouseStockLinker tileWarehouseStockLinker = (TileWarehouseStockLinker)tileentity;
            doPower = tileWarehouseStockLinker.getEqualityHandle();
        }
        return doPower;
    }

    public static void setActiveState(boolean active, World world, BlockPos pos) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(active)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(world, pos, state, player, stack);
        if (!world.field_72995_K && stack.func_77978_p() != null && (tileentity = world.func_175625_s(pos)) instanceof TileWarehouseStockLinker) {
            TileWarehouseStockLinker tileWarehouseStockLinker = (TileWarehouseStockLinker)tileentity;
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("warehousePosTag");
            tileWarehouseStockLinker.setWarehousePos(NBTUtil.func_186861_c((NBTTagCompound)tag));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING, LIT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)BlockTools.getHorizontalFacingFromMeta(meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).ordinal();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockRotationHandler.RotationType getRotationType() {
        return BlockRotationHandler.RotationType.FOUR_WAY;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean invertFacing() {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABBS.get(state.func_177229_b((IProperty)CoreProperties.FACING));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return WorldTools.clickInteractableTileWithHand(world, pos, player, hand);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        return WorldTools.sendClientEventToTile((IBlockAccess)world, pos, id, param);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        NetworkHandler.registerGui(32, GuiWarehouseStockLinker.class);
    }

    static {
        float wmin = 0.125f;
        float wmax = 0.875f;
        float hmin = 0.375f;
        float hmax = 0.875f;
        AABBS = ImmutableMap.of((Object)EnumFacing.WEST, (Object)new AxisAlignedBB((double)wmax, (double)hmin, 0.0, 1.0, (double)hmax, 1.0), (Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.0, (double)hmin, 0.0, (double)wmin, (double)hmax, 1.0), (Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, (double)hmin, 0.0, 1.0, (double)hmax, (double)wmin), (Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, (double)hmin, (double)wmax, 1.0, (double)hmax, 1.0));
    }
}

