/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouse;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.inventory.ItemHashEntry;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class ContainerWarehouseControl
extends ContainerTileBase<TileWarehouse> {
    private static final String SLOT_CLICK_TAG = "slotClick";
    private static final String REQ_ITEM_TAG = "reqItem";
    private static final String CHANGE_LIST_TAG = "changeList";
    private static final String MAX_STORAGE_TAG = "maxStorage";
    private static final String SORT_TYPE_TAG = "sortType";
    private static final String SORT_ORDER_TAG = "sortOrder";
    public ItemQuantityMap itemMap = new ItemQuantityMap();
    private final ItemQuantityMap cache = new ItemQuantityMap();
    private boolean shouldUpdate = true;
    public int maxStorage = 0;
    public int currentStored = 0;

    public ContainerWarehouseControl(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        this.addPlayerSlots(142);
        ((TileWarehouse)this.tileEntity).addViewer(this);
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        ((TileWarehouse)this.tileEntity).removeViewer(this);
        super.func_75134_a(par1EntityPlayer);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotClickedIndex) {
        if (player.field_70170_p.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        Slot slot = this.func_75139_a(slotClickedIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        if ((stack = ((TileWarehouse)this.tileEntity).tryAdd(stack)).func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
        return ItemStack.field_190927_a;
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(SLOT_CLICK_TAG)) {
            NBTTagCompound reqTag = tag.func_74775_l(SLOT_CLICK_TAG);
            ItemStack item = ItemStack.field_190927_a;
            if (reqTag.func_74764_b(REQ_ITEM_TAG)) {
                item = new ItemStack(reqTag.func_74775_l(REQ_ITEM_TAG));
            }
            ((TileWarehouse)this.tileEntity).handleSlotClick(this.player, item, reqTag.func_74767_n("isShiftClick"), reqTag.func_74767_n("isRightClick"));
        } else if (tag.func_74764_b(CHANGE_LIST_TAG)) {
            this.handleChangeList(tag.func_150295_c(CHANGE_LIST_TAG, 10));
        } else {
            if (tag.func_74764_b(MAX_STORAGE_TAG)) {
                this.maxStorage = tag.func_74762_e(MAX_STORAGE_TAG);
            }
            if (tag.func_74764_b(SORT_TYPE_TAG)) {
                ((TileWarehouse)this.tileEntity).setSortType(InventoryTools.ComparatorItemHashEntry.SortType.values()[tag.func_74771_c(SORT_TYPE_TAG)]);
            }
            if (tag.func_74764_b(SORT_ORDER_TAG)) {
                ((TileWarehouse)this.tileEntity).setSortOrder(InventoryTools.ComparatorItemHashEntry.SortOrder.values()[tag.func_74771_c(SORT_ORDER_TAG)]);
            }
        }
        this.currentStored = this.itemMap.getTotalItemCount();
        this.refreshGui();
    }

    public void handleClientRequestSpecific(@Nullable NBTTagCompound itemTag, int count, boolean isShiftClick, boolean isRightClick) {
        NBTTagCompound tag = new NBTTagCompound();
        if (itemTag != null) {
            ItemStack copy = new ItemStack(itemTag);
            copy.func_190920_e(Math.min(count, copy.func_77976_d()));
            tag.func_74782_a(REQ_ITEM_TAG, (NBTBase)copy.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74757_a("isShiftClick", isShiftClick);
        tag.func_74757_a("isRightClick", isRightClick);
        NBTTagCompound pktTag = new NBTTagCompound();
        pktTag.func_74782_a(SLOT_CLICK_TAG, (NBTBase)tag);
        this.sendDataToServer(pktTag);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.shouldUpdate) {
            this.synchItemMaps();
            this.shouldUpdate = false;
        }
        if (this.maxStorage != ((TileWarehouse)this.tileEntity).getMaxStorage()) {
            this.maxStorage = ((TileWarehouse)this.tileEntity).getMaxStorage();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a(MAX_STORAGE_TAG, this.maxStorage);
            tag.func_74774_a(SORT_ORDER_TAG, (byte)this.getSortOrder().ordinal());
            tag.func_74774_a(SORT_TYPE_TAG, (byte)this.getSortType().ordinal());
            this.sendDataToClient(tag);
        }
    }

    private void handleChangeList(NBTTagList changeList) {
        for (int i = 0; i < changeList.func_74745_c(); ++i) {
            NBTTagCompound tag = changeList.func_150305_b(i);
            this.itemMap.putEntryFromNBT(tag);
        }
    }

    private void synchItemMaps() {
        int qty;
        this.cache.clear();
        ((TileWarehouse)this.tileEntity).getItems(this.cache);
        ItemQuantityMap warehouseItemMap = this.cache;
        NBTTagList changeList = new NBTTagList();
        for (ItemHashEntry wrap : this.itemMap.keySet()) {
            qty = this.itemMap.getCount(wrap);
            if (qty == warehouseItemMap.getCount(wrap)) continue;
            qty = warehouseItemMap.getCount(wrap);
            changeList.func_74742_a((NBTBase)warehouseItemMap.writeEntryToNBT(wrap));
            this.itemMap.put(wrap, qty);
        }
        for (ItemHashEntry entry : warehouseItemMap.keySet()) {
            if (this.itemMap.contains(entry)) continue;
            qty = warehouseItemMap.getCount(entry);
            changeList.func_74742_a((NBTBase)warehouseItemMap.writeEntryToNBT(entry));
            this.itemMap.put(entry, qty);
        }
        if (changeList.func_74745_c() > 0) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a(CHANGE_LIST_TAG, (NBTBase)changeList);
            this.sendDataToClient(tag);
        }
    }

    public void onWarehouseInventoryUpdated() {
        this.shouldUpdate = true;
    }

    public InventoryTools.ComparatorItemHashEntry.SortType getSortType() {
        return ((TileWarehouse)this.tileEntity).getSortType();
    }

    public void setSortType(InventoryTools.ComparatorItemHashEntry.SortType sortType) {
        ((TileWarehouse)this.tileEntity).setSortType(sortType);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a(SORT_TYPE_TAG, (byte)sortType.ordinal());
        this.sendDataToServer(tag);
    }

    public InventoryTools.ComparatorItemHashEntry.SortOrder getSortOrder() {
        return ((TileWarehouse)this.tileEntity).getSortOrder();
    }

    public void setSortOrder(InventoryTools.ComparatorItemHashEntry.SortOrder sortOrder) {
        ((TileWarehouse)this.tileEntity).setSortOrder(sortOrder);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a(SORT_ORDER_TAG, (byte)sortOrder.ordinal());
        this.sendDataToServer(tag);
    }

    public boolean isWarehouseFull() {
        return this.currentStored == this.maxStorage;
    }
}

