/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouse;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseCraftingStation;
import net.shadowmage.ancientwarfare.core.container.ContainerCraftingRecipeMemory;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.container.ICraftingContainer;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.crafting.ICraftingRecipe;
import net.shadowmage.ancientwarfare.core.inventory.ItemHashEntry;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class ContainerWarehouseCraftingStation
extends ContainerTileBase<TileWarehouseCraftingStation>
implements ICraftingContainer {
    private static final int BOOK_SLOT = 1;
    private static final String CHANGE_LIST_TAG = "changeList";
    private static final int CRAFTING_SLOT = 0;
    public ContainerCraftingRecipeMemory containerCrafting;
    private ItemQuantityMap itemMap = new ItemQuantityMap();
    private final ItemQuantityMap cache = new ItemQuantityMap();
    private boolean shouldUpdate = true;
    private int currentCraftTotalSize = 0;
    private IItemHandlerModifiable warehouseItemHandler = null;

    public ContainerWarehouseCraftingStation(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        this.containerCrafting = new ContainerCraftingRecipeMemory(((TileWarehouseCraftingStation)this.tileEntity).craftingRecipeMemory, player){

            @Override
            protected ContainerCraftingRecipeMemory.OnTakeResult handleOnTake(EntityPlayer player, ItemStack stack) {
                if (ContainerWarehouseCraftingStation.this.warehouseItemHandler == null) {
                    return new ContainerCraftingRecipeMemory.OnTakeResult(this, EnumActionResult.PASS, stack);
                }
                ICraftingRecipe recipe = ((TileWarehouseCraftingStation)ContainerWarehouseCraftingStation.this.tileEntity).craftingRecipeMemory.getRecipe();
                NonNullList<ItemStack> reusableStacks = AWCraftingManager.getReusableStacks(recipe, ((TileWarehouseCraftingStation)ContainerWarehouseCraftingStation.this.tileEntity).craftingRecipeMemory.craftMatrix);
                CombinedInvWrapper combinedHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{new ItemStackHandler(reusableStacks), ContainerWarehouseCraftingStation.this.warehouseItemHandler});
                NonNullList<ItemStack> resources = AWCraftingManager.getRecipeInventoryMatch(recipe, ContainerWarehouseCraftingStation.this.containerCrafting.getCraftingStacks(), s -> ((TileWarehouseCraftingStation)ContainerWarehouseCraftingStation.this.tileEntity).getWarehouse().getCountOf((ItemStack)s) >= s.func_190916_E(), (IItemHandler)combinedHandler);
                if (!resources.isEmpty()) {
                    resources = InventoryTools.removeItems(resources, reusableStacks);
                    InventoryTools.removeItems((IItemHandler)ContainerWarehouseCraftingStation.this.warehouseItemHandler, resources);
                    NonNullList<ItemStack> remainingItems = InventoryTools.removeItems(((TileWarehouseCraftingStation)ContainerWarehouseCraftingStation.this.tileEntity).craftingRecipeMemory.getRemainingItems(AWCraftingManager.fillCraftingMatrixFromInventory(resources)), reusableStacks);
                    InventoryTools.insertOrDropItems((IItemHandler)ContainerWarehouseCraftingStation.this.warehouseItemHandler, remainingItems, ((TileWarehouseCraftingStation)ContainerWarehouseCraftingStation.this.tileEntity).func_145831_w(), ((TileWarehouseCraftingStation)ContainerWarehouseCraftingStation.this.tileEntity).func_174877_v());
                    return new ContainerCraftingRecipeMemory.OnTakeResult(this, EnumActionResult.SUCCESS, stack);
                }
                return new ContainerCraftingRecipeMemory.OnTakeResult(this, EnumActionResult.PASS, stack);
            }

            @Override
            protected boolean canTakeStackFromOutput(EntityPlayer player) {
                return true;
            }
        };
        for (Slot slot : this.containerCrafting.getSlots()) {
            this.func_75146_a(slot);
        }
        int y1 = 70;
        this.addPlayerSlots(y1);
        TileWarehouse warehouse = ((TileWarehouseCraftingStation)this.tileEntity).getWarehouse();
        if (warehouse != null) {
            warehouse.addCraftingViewer(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190896_a(List<ItemStack> stacks) {
        this.containerCrafting.setOpening(true);
        super.func_190896_a(stacks);
        this.containerCrafting.setOpening(false);
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        this.containerCrafting.setOpening(true);
        super.func_75141_a(slotID, stack);
        this.containerCrafting.setOpening(false);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId == 0) {
            this.warehouseItemHandler = ((TileWarehouseCraftingStation)this.tileEntity).getWarehouse() != null ? ((TileWarehouseCraftingStation)this.tileEntity).getWarehouse().getItemHandler() : null;
        }
        ItemStack result = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        this.currentCraftTotalSize = 0;
        return result;
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        TileWarehouse warehouse = ((TileWarehouseCraftingStation)this.tileEntity).getWarehouse();
        if (warehouse != null) {
            warehouse.removeCraftingViewer(this);
        }
        super.func_75134_a(par1EntityPlayer);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
        if (slotClickedIndex == 0 && !this.updateAndCheckCraftStackOrLessInTotal()) {
            return ItemStack.field_190927_a;
        }
        ItemStack slotStackCopy = ItemStack.field_190927_a;
        Slot theSlot = this.func_75139_a(slotClickedIndex);
        if (theSlot.func_75216_d()) {
            ItemStack slotStack = theSlot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            int playerSlotStart = 2 + ((TileWarehouseCraftingStation)this.tileEntity).craftingRecipeMemory.craftMatrix.func_70302_i_();
            if (slotClickedIndex < playerSlotStart ? !this.func_75135_a(slotStack, playerSlotStart, playerSlotStart + this.playerSlots, false) : slotClickedIndex < playerSlotStart + this.playerSlots && !this.func_75135_a(slotStack, 1, 2, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                theSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                theSlot.func_75218_e();
            }
            if (slotStack.func_190916_E() == slotStackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            theSlot.func_190901_a(par1EntityPlayer, slotStack);
        }
        return slotStackCopy;
    }

    private boolean updateAndCheckCraftStackOrLessInTotal() {
        ItemStack craftedStack = this.func_75139_a(0).func_75211_c();
        this.currentCraftTotalSize += craftedStack.func_190916_E();
        return this.currentCraftTotalSize <= craftedStack.func_77976_d();
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(CHANGE_LIST_TAG)) {
            this.handleChangeList(tag.func_150295_c(CHANGE_LIST_TAG, 10));
        } else if (tag.func_74764_b("recipe")) {
            this.containerCrafting.handleRecipeUpdate(tag);
        }
        this.refreshGui();
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.shouldUpdate) {
            this.synchItemMaps();
            this.shouldUpdate = false;
        }
    }

    private void handleChangeList(NBTTagList changeList) {
        for (int i = 0; i < changeList.func_74745_c(); ++i) {
            NBTTagCompound tag = changeList.func_150305_b(i);
            this.itemMap.putEntryFromNBT(tag);
        }
        TileWarehouse warehouse = ((TileWarehouseCraftingStation)this.tileEntity).getWarehouse();
        if (warehouse != null) {
            warehouse.clearItemCache();
            warehouse.addItemsToCache(this.itemMap);
        }
    }

    private void synchItemMaps() {
        int qty;
        this.cache.clear();
        TileWarehouse warehouse = ((TileWarehouseCraftingStation)this.tileEntity).getWarehouse();
        if (warehouse != null) {
            warehouse.getItems(this.cache);
        }
        ItemQuantityMap warehouseItemMap = this.cache;
        NBTTagList changeList = new NBTTagList();
        for (ItemHashEntry wrap : this.itemMap.keySet()) {
            qty = this.itemMap.getCount(wrap);
            if (qty == warehouseItemMap.getCount(wrap)) continue;
            qty = warehouseItemMap.getCount(wrap);
            changeList.func_74742_a((NBTBase)warehouseItemMap.writeEntryToNBT(wrap));
            this.itemMap.put(wrap, qty);
        }
        for (ItemHashEntry entry : warehouseItemMap.keySet()) {
            if (this.itemMap.contains(entry)) continue;
            qty = warehouseItemMap.getCount(entry);
            changeList.func_74742_a((NBTBase)warehouseItemMap.writeEntryToNBT(entry));
            this.itemMap.put(entry, qty);
        }
        if (changeList.func_74745_c() > 0) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a(CHANGE_LIST_TAG, (NBTBase)changeList);
            this.sendDataToClient(tag);
        }
    }

    public void onWarehouseInventoryUpdated() {
        this.shouldUpdate = true;
    }

    @Override
    public ContainerCraftingRecipeMemory getCraftingMemoryContainer() {
        return this.containerCrafting;
    }

    @Override
    public IItemHandlerModifiable[] getInventories() {
        if (((TileWarehouseCraftingStation)this.tileEntity).getWarehouse() == null) {
            return new IItemHandlerModifiable[]{new PlayerInvWrapper(this.player.field_71071_by)};
        }
        return new IItemHandlerModifiable[]{((TileWarehouseCraftingStation)this.tileEntity).getWarehouse().getItemHandler(), new PlayerInvWrapper(this.player.field_71071_by)};
    }

    @Override
    public boolean pushCraftingMatrixToInventories() {
        InvWrapper craftMatrixWrapper = new InvWrapper((IInventory)((TileWarehouseCraftingStation)this.tileEntity).craftingRecipeMemory.craftMatrix);
        NonNullList<ItemStack> craftingItems = InventoryTools.getItems((IItemHandler)craftMatrixWrapper);
        Object inventories = ((TileWarehouseCraftingStation)this.tileEntity).getWarehouse() == null ? new PlayerInvWrapper(this.player.field_71071_by) : new CombinedInvWrapper(new IItemHandlerModifiable[]{((TileWarehouseCraftingStation)this.tileEntity).getWarehouse().getItemHandler(), new PlayerInvWrapper(this.player.field_71071_by)});
        if (InventoryTools.insertItems((IItemHandler)inventories, craftingItems, true).isEmpty()) {
            List<ItemStack> remainingItems = InventoryTools.insertItems((IItemHandler)inventories, craftingItems, false);
            InventoryTools.emptyInventory((IItemHandler)craftMatrixWrapper);
            if (!remainingItems.isEmpty()) {
                InventoryTools.insertItems((IItemHandler)craftMatrixWrapper, remainingItems, false);
                return false;
            }
            return true;
        }
        return false;
    }
}

