/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStorage;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseStorageFilter;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.inventory.ItemHashEntry;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;

public class ContainerWarehouseStorage
extends ContainerTileBase<TileWarehouseStorage> {
    private static final String REQ_ITEM_TAG = "reqItem";
    private static final String IS_SHIFT_CLICK_TAG = "isShiftClick";
    private static final String IS_RIGHT_CLICK_TAG = "isRightClick";
    private static final String SLOT_CLICK_TAG = "slotClick";
    private static final String FILTER_LIST_TAG = "filterList";
    private static final String CHANGE_LIST_TAG = "changeList";
    private boolean shouldSynch = true;
    private ItemQuantityMap cache = new ItemQuantityMap();
    public ItemQuantityMap itemMap = new ItemQuantityMap();
    public List<WarehouseStorageFilter> filters = new ArrayList<WarehouseStorageFilter>();

    public ContainerWarehouseStorage(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        ((TileWarehouseStorage)this.tileEntity).addViewer(this);
        this.filters.addAll(((TileWarehouseStorage)this.tileEntity).getFilters());
        this.addPlayerSlots(156);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotClickedIndex) {
        if (player.field_70170_p.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        Slot slot = this.func_75139_a(slotClickedIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        if ((stack = ((TileWarehouseStorage)this.tileEntity).tryAdd(stack)).func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
        return ItemStack.field_190927_a;
    }

    public void handleClientRequestSpecific(ItemStack stack, boolean isShiftClick, boolean isRightClick) {
        NBTTagCompound tag = new NBTTagCompound();
        if (!stack.func_190926_b()) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(Math.min(stack.func_190916_E(), stack.func_77976_d()));
            tag.func_74782_a(REQ_ITEM_TAG, (NBTBase)copy.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74757_a(IS_SHIFT_CLICK_TAG, isShiftClick);
        tag.func_74757_a(IS_RIGHT_CLICK_TAG, isRightClick);
        NBTTagCompound pktTag = new NBTTagCompound();
        pktTag.func_74782_a(SLOT_CLICK_TAG, (NBTBase)tag);
        this.sendDataToServer(pktTag);
    }

    @Override
    public void sendInitData() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTHelper.writeSerializablesTo(tag, FILTER_LIST_TAG, this.filters);
        this.sendDataToClient(tag);
    }

    public void sendFiltersToServer() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTHelper.writeSerializablesTo(tag, FILTER_LIST_TAG, this.filters);
        this.sendDataToServer(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(FILTER_LIST_TAG)) {
            List<WarehouseStorageFilter> deserializedFilters = NBTHelper.deserializeListFrom(tag, FILTER_LIST_TAG, WarehouseStorageFilter::new);
            if (this.player.field_70170_p.field_72995_K) {
                this.filters = deserializedFilters;
                this.refreshGui();
            } else {
                ((TileWarehouseStorage)this.tileEntity).setFilters(deserializedFilters);
            }
        } else if (tag.func_74764_b(SLOT_CLICK_TAG)) {
            NBTTagCompound reqTag = tag.func_74775_l(SLOT_CLICK_TAG);
            ItemStack item = ItemStack.field_190927_a;
            if (reqTag.func_74764_b(REQ_ITEM_TAG)) {
                item = new ItemStack(reqTag.func_74775_l(REQ_ITEM_TAG));
            }
            ((TileWarehouseStorage)this.tileEntity).handleSlotClick(this.player, item, reqTag.func_74767_n(IS_SHIFT_CLICK_TAG), reqTag.func_74767_n(IS_RIGHT_CLICK_TAG));
        } else if (tag.func_74764_b(CHANGE_LIST_TAG)) {
            this.handleChangeList(tag.func_150295_c(CHANGE_LIST_TAG, 10));
            this.refreshGui();
        }
        super.handlePacketData(tag);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.shouldSynch) {
            this.synchItemMaps();
            this.shouldSynch = false;
        }
    }

    private void handleChangeList(NBTTagList changeList) {
        for (int i = 0; i < changeList.func_74745_c(); ++i) {
            NBTTagCompound tag = changeList.func_150305_b(i);
            this.itemMap.putEntryFromNBT(tag);
        }
    }

    private void synchItemMaps() {
        int qty;
        this.cache.clear();
        ((TileWarehouseStorage)this.tileEntity).addItems(this.cache);
        ItemQuantityMap warehouseItemMap = this.cache;
        NBTTagList changeList = new NBTTagList();
        for (ItemHashEntry wrap : this.itemMap.keySet()) {
            qty = this.itemMap.getCount(wrap);
            if (qty == warehouseItemMap.getCount(wrap)) continue;
            qty = warehouseItemMap.getCount(wrap);
            changeList.func_74742_a((NBTBase)warehouseItemMap.writeEntryToNBT(wrap));
            this.itemMap.put(wrap, qty);
        }
        for (ItemHashEntry entry : warehouseItemMap.keySet()) {
            if (this.itemMap.contains(entry)) continue;
            qty = warehouseItemMap.getCount(entry);
            changeList.func_74742_a((NBTBase)warehouseItemMap.writeEntryToNBT(entry));
            this.itemMap.put(entry, qty);
        }
        if (changeList.func_74745_c() > 0) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a(CHANGE_LIST_TAG, (NBTBase)changeList);
            this.sendDataToClient(tag);
        }
    }

    public void onStorageInventoryUpdated() {
        this.shouldSynch = true;
    }

    public void onFilterListUpdated() {
        this.filters.clear();
        this.filters.addAll(((TileWarehouseStorage)this.tileEntity).getFilters());
        this.sendInitData();
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        ((TileWarehouseStorage)this.tileEntity).removeViewer(this);
        super.func_75134_a(par1EntityPlayer);
    }
}

