/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.shadowmage.ancientwarfare.automation.render.AnimatedBlockRenderer;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueBase;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public abstract class BaseTorqueRenderer<T extends TileTorqueBase>
extends AnimatedBlockRenderer {
    protected BaseTorqueRenderer(String modelPath) {
        super(modelPath);
    }

    @Override
    protected Collection<CCModel> applyModelTransforms(Collection<CCModel> modelGroups, EnumFacing face, IExtendedBlockState state) {
        HashSet transformedGroups = Sets.newHashSet();
        EnumFacing frontFacing = (EnumFacing)state.getValue(CoreProperties.UNLISTED_FACING);
        if (((Boolean)state.getValue(AutomationProperties.DYNAMIC)).booleanValue()) {
            ImmutableMap properties = state.getUnlistedProperties();
            float[] rotations = new float[6];
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!properties.containsKey(AutomationProperties.ROTATIONS[facing.func_176745_a()])) continue;
                rotations[facing.func_176745_a()] = ((Float)state.getValue(AutomationProperties.ROTATIONS[facing.func_176745_a()])).floatValue();
            }
            this.transformMovingParts(transformedGroups, frontFacing, rotations, state);
        } else {
            transformedGroups.addAll(this.rotateFacing(modelGroups, frontFacing));
        }
        return transformedGroups;
    }

    @Override
    protected void renderItemModels(CCRenderState ccrs, ItemStack stack) {
        super.renderItemModels(ccrs, stack);
        HashSet movingParts = Sets.newHashSet();
        this.transformMovingParts(movingParts, EnumFacing.NORTH, new float[6], null);
        movingParts.forEach(m -> m.render(ccrs, new IVertexOperation[]{this.getIconTransform(stack)}));
    }

    protected abstract void transformMovingParts(Collection<CCModel> var1, EnumFacing var2, float[] var3, @Nullable IExtendedBlockState var4);

    @Override
    public IExtendedBlockState handleState(IExtendedBlockState state, IBlockAccess access, BlockPos pos) {
        EnumFacing facing = EnumFacing.NORTH;
        Optional<TileTorqueBase> tileentity = WorldTools.getTile(access, pos, TileTorqueBase.class);
        if (tileentity.isPresent()) {
            TileTorqueBase torquePart = tileentity.get();
            facing = torquePart.getPrimaryFacing();
        }
        IExtendedBlockState updatedState = state.withProperty(CoreProperties.UNLISTED_FACING, (Object)facing);
        updatedState = updatedState.withProperty(AutomationProperties.DYNAMIC, (Object)false);
        for (EnumFacing f : EnumFacing.field_82609_l) {
            updatedState = updatedState.withProperty(AutomationProperties.ROTATIONS[f.func_176745_a()], (Object)Float.valueOf(0.0f));
        }
        if (tileentity.isPresent()) {
            updatedState = this.handleAdditionalProperties(updatedState, tileentity.get());
        }
        return updatedState;
    }

    protected IExtendedBlockState handleAdditionalProperties(IExtendedBlockState state, T tileEntity) {
        return state;
    }
}

