/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IControlledTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IControllerTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public abstract class TileControlled
extends TileUpdatable
implements IControlledTile,
ITickable {
    private static final String CONTROLLER_POSITION_TAG = "controllerPosition";
    private boolean init;
    private TileWarehouseBase controller;
    private BlockPos controllerPosition;

    public final void func_73660_a() {
        if (!this.init) {
            this.init = true;
            if (!this.loadController()) {
                this.searchForController();
            }
        }
        this.updateTile();
    }

    private boolean loadController() {
        BlockPos pos = this.controllerPosition;
        this.controllerPosition = null;
        if (pos != null && this.controller == null) {
            WorldTools.getTile((IBlockAccess)this.field_145850_b, pos, IControllerTile.class).filter(this::isValidController).ifPresent(t -> t.addControlledTile(this));
        }
        return this.controller != null;
    }

    protected abstract void updateTile();

    public void searchForController() {
        BlockPos min = this.field_174879_c.func_177982_a(-16, -4, -16);
        BlockPos max = this.field_174879_c.func_177982_a(16, 4, 16);
        for (TileEntity te : WorldTools.getTileEntitiesInArea(this.field_145850_b, min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p())) {
            if (!(te instanceof IControllerTile) || !this.isValidController((IControllerTile)te)) continue;
            ((IControllerTile)te).addControlledTile(this);
            break;
        }
    }

    @Override
    public boolean isValidController(IControllerTile tile) {
        return BlockTools.isPositionWithinBounds(this.func_174877_v(), tile.getWorkBoundsMin(), tile.getWorkBoundsMax());
    }

    public final void func_145843_s() {
        if (this.controller != null) {
            this.controller.removeControlledTile(this);
        }
        this.controller = null;
        this.init = false;
        super.func_145843_s();
    }

    public final void func_145829_t() {
        super.func_145829_t();
        if (this.controller != null) {
            this.controller.addControlledTile(this);
        }
    }

    @Override
    public final void setController(@Nullable TileWarehouseBase tile) {
        this.controller = tile;
        this.controllerPosition = tile == null ? null : tile.getPosisition();
        this.onControllerChanged();
    }

    protected void onControllerChanged() {
    }

    @Override
    public final Optional<TileWarehouseBase> getController() {
        return Optional.ofNullable(this.controller);
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b(CONTROLLER_POSITION_TAG)) {
            this.controllerPosition = BlockPos.func_177969_a((long)tag.func_74763_f(CONTROLLER_POSITION_TAG));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.controllerPosition != null) {
            tag.func_74772_a(CONTROLLER_POSITION_TAG, this.controllerPosition.func_177986_g());
        }
        return tag;
    }

    public final boolean equals(Object obj) {
        return this == obj || obj instanceof TileControlled && this.field_145850_b == ((TileControlled)obj).func_145831_w() && this.func_174877_v().equals((Object)((TileControlled)obj).func_174877_v());
    }

    public final int hashCode() {
        return this.func_174877_v().hashCode();
    }
}

