/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseStockViewer;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IControllerTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileControlled;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.owner.IOwnable;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;

public class TileWarehouseStockViewer
extends TileControlled
implements IOwnable,
IInteractableTile {
    private static final String FILTER_LIST_TAG = "filterList";
    private final List<WarehouseStockFilter> filters = new ArrayList<WarehouseStockFilter>();
    private Owner owner = Owner.EMPTY;
    private final Set<ContainerWarehouseStockViewer> viewers = new HashSet<ContainerWarehouseStockViewer>();

    private void updateViewers() {
        for (ContainerWarehouseStockViewer viewer : this.viewers) {
            viewer.onFiltersChanged();
        }
    }

    public void addViewer(ContainerWarehouseStockViewer viewer) {
        this.viewers.add(viewer);
    }

    public void removeViewer(ContainerWarehouseStockViewer viewer) {
        this.viewers.remove((Object)viewer);
    }

    public List<WarehouseStockFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<WarehouseStockFilter> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
        this.recountFilters();
        BlockTools.notifyBlockUpdate(this);
    }

    private void recountFilters() {
        Optional<TileWarehouseBase> controller = this.getController();
        if (!controller.isPresent()) {
            for (WarehouseStockFilter filter : this.filters) {
                filter.setQuantity(0);
            }
        } else {
            for (WarehouseStockFilter filter : this.filters) {
                filter.setQuantity(filter.getFilterItem().func_190926_b() ? 0 : controller.get().getCountOf(filter.getFilterItem()));
            }
        }
    }

    @Override
    public boolean isValidController(IControllerTile tile) {
        return BlockTools.isPositionWithinBounds(this.func_174877_v(), tile.getWorkBoundsMin().func_177982_a(-1, 0, -1), tile.getWorkBoundsMax().func_177982_a(1, 0, 1));
    }

    @Override
    protected void onControllerChanged() {
        this.onWarehouseInventoryUpdated();
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return this.owner.isOwnerOrSameTeamOrFriend((Entity)player);
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = new Owner(player);
    }

    @Override
    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && this.isOwner(player)) {
            NetworkHandler.INSTANCE.openGui(player, 20, this.field_174879_c);
        }
        return true;
    }

    @Override
    protected void updateTile() {
    }

    void onWarehouseInventoryUpdated() {
        BlockTools.notifyBlockUpdate(this);
        this.recountFilters();
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        NBTHelper.writeSerializablesTo(tag, FILTER_LIST_TAG, this.filters);
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.filters.clear();
        this.filters.addAll(NBTHelper.deserializeListFrom(tag, FILTER_LIST_TAG, WarehouseStockFilter::new));
        BlockTools.notifyBlockUpdate(this);
        this.updateViewers();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.filters.addAll(NBTHelper.deserializeListFrom(tag, FILTER_LIST_TAG, WarehouseStockFilter::new));
        this.owner = Owner.deserializeFromNBT(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTHelper.writeSerializablesTo(tag, FILTER_LIST_TAG, this.filters);
        this.owner.serializeToNBT(tag);
        return tag;
    }

    public static class WarehouseStockFilter
    implements INBTSerializable<NBTTagCompound> {
        private static final String ITEM_TAG = "item";
        private static final String QUANTITY_TAG = "quantity";
        private ItemStack item = ItemStack.field_190927_a;
        private int quantity;

        public WarehouseStockFilter() {
        }

        public WarehouseStockFilter(ItemStack item, int qty) {
            this.setQuantity(qty);
            this.setItem(item);
        }

        public void setItem(ItemStack item) {
            this.item = item;
        }

        public void setQuantity(int quantity) {
            this.quantity = quantity;
        }

        public ItemStack getFilterItem() {
            return this.item;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (!this.item.func_190926_b()) {
                tag.func_74782_a(ITEM_TAG, (NBTBase)this.item.func_77955_b(new NBTTagCompound()));
            }
            tag.func_74768_a(QUANTITY_TAG, this.quantity);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound tag) {
            this.setItem(tag.func_74764_b(ITEM_TAG) ? new ItemStack(tag.func_74775_l(ITEM_TAG)) : ItemStack.field_190927_a);
            this.setQuantity(tag.func_74762_e(QUANTITY_TAG));
        }
    }
}

