/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.WorldSavedData;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class WarehouseDebuggerData
extends WorldSavedData {
    private static final int TRACKING_INTERVAL = 20;
    private Set<BlockPos> trackedWarehouses = new HashSet<BlockPos>();
    private Map<BlockPos, Map<ItemStack, Integer>> itemCounts = new HashMap<BlockPos, Map<ItemStack, Integer>>();
    private int currentCooldown = 0;

    public WarehouseDebuggerData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        return compound;
    }

    public boolean decreaseAndCheckCooldown() {
        --this.currentCooldown;
        if (this.currentCooldown <= 0) {
            this.currentCooldown = 20;
            return true;
        }
        return false;
    }

    public Set<BlockPos> getTrackedWarehouses() {
        return this.trackedWarehouses;
    }

    public void removeTrackedWarehouse(BlockPos warehousePos) {
        this.trackedWarehouses.remove(warehousePos);
        this.itemCounts.remove(warehousePos);
    }

    public Map<ItemStack, Integer> getItemCounts(BlockPos warehousePos) {
        if (!this.itemCounts.containsKey(warehousePos)) {
            this.itemCounts.put(warehousePos, new HashMap());
        }
        return this.itemCounts.get(warehousePos);
    }

    public void addTrackedWarehouse(BlockPos pos) {
        this.trackedWarehouses.add(pos);
    }

    public void setItemCounts(BlockPos pos, Map<ItemStack, Integer> itemCounts) {
        this.itemCounts.put(pos, itemCounts);
    }

    public void removeItem(BlockPos warehousePos, ItemStack stack, int count) {
        if (!this.trackedWarehouses.contains(warehousePos)) {
            return;
        }
        Iterator<Map.Entry<ItemStack, Integer>> it = this.itemCounts.get(warehousePos).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ItemStack, Integer> entry = it.next();
            if (!InventoryTools.doItemStacksMatch(entry.getKey(), stack)) continue;
            entry.setValue(entry.getValue() - count);
            if (entry.getValue() > 0) break;
            it.remove();
            break;
        }
    }

    public void addItem(BlockPos warehousePos, ItemStack stack, int count) {
        if (!this.trackedWarehouses.contains(warehousePos)) {
            return;
        }
        for (Map.Entry<ItemStack, Integer> entry : this.itemCounts.get(warehousePos).entrySet()) {
            if (!InventoryTools.doItemStacksMatch(entry.getKey(), stack)) continue;
            entry.setValue(entry.getValue() + count);
            return;
        }
        this.itemCounts.get(warehousePos).put(stack.func_77946_l(), count);
    }

    public boolean isTrackingWarehouse(BlockPos pos) {
        return this.trackedWarehouses.contains(pos);
    }
}

