/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IWarehouseStorageTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseStorageFilter;
import net.shadowmage.ancientwarfare.core.inventory.ItemHashEntry;

public class WarehouseStorageMap {
    Set<IWarehouseStorageTile> unfilteredStorage = new HashSet<IWarehouseStorageTile>();
    Set<IWarehouseStorageTile> filteredStorage = new HashSet<IWarehouseStorageTile>();
    Map<ItemHashEntry, Set<IWarehouseStorageTile>> storageMap = new HashMap<ItemHashEntry, Set<IWarehouseStorageTile>>();

    public final void addStorageTile(IWarehouseStorageTile tile) {
        this.addTileFilters(tile, tile.getFilters());
    }

    public final void removeStorageTile(IWarehouseStorageTile tile) {
        this.removeTileFilters(tile, tile.getFilters());
    }

    public final void updateTileFilters(IWarehouseStorageTile tile, List<WarehouseStorageFilter> oldFilters, List<WarehouseStorageFilter> newFilters) {
        this.removeTileFilters(tile, oldFilters);
        this.addTileFilters(tile, newFilters);
    }

    public final Set<IWarehouseStorageTile> getFilterSetFor(ItemStack filter) {
        return this.getOrCreateStorageSet(new ItemHashEntry(filter));
    }

    public final Set<IWarehouseStorageTile> getUnFilteredSet() {
        return this.unfilteredStorage;
    }

    public final List<IWarehouseStorageTile> getDestinations() {
        ArrayList out = Lists.newArrayList();
        out.addAll(this.filteredStorage);
        out.addAll(this.unfilteredStorage);
        return out;
    }

    public final List<IWarehouseStorageTile> getDestinations(ItemStack filter) {
        ArrayList out = Lists.newArrayList();
        ItemHashEntry key = new ItemHashEntry(filter);
        Set<IWarehouseStorageTile> set = this.getOrCreateStorageSet(key);
        out.addAll(set);
        out.addAll(this.unfilteredStorage);
        return out;
    }

    private Set<IWarehouseStorageTile> getOrCreateStorageSet(ItemHashEntry key) {
        Set set = this.storageMap.computeIfAbsent(key, k -> new HashSet());
        return set;
    }

    private void removeTileFilters(IWarehouseStorageTile tile, List<WarehouseStorageFilter> filters) {
        if (filters.isEmpty()) {
            this.unfilteredStorage.remove(tile);
        } else {
            this.filteredStorage.remove(tile);
            for (WarehouseStorageFilter filter : filters) {
                if (filter.hashKey == null) continue;
                this.getOrCreateStorageSet(filter.hashKey).remove(tile);
            }
        }
    }

    private void addTileFilters(IWarehouseStorageTile tile, List<WarehouseStorageFilter> filters) {
        if (filters.isEmpty()) {
            this.unfilteredStorage.add(tile);
        } else {
            this.filteredStorage.add(tile);
            for (WarehouseStorageFilter filter : filters) {
                if (filter.hashKey == null) continue;
                this.getOrCreateStorageSet(filter.hashKey).add(tile);
            }
        }
    }
}

