/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite.cropfarm;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.automation.tile.worksite.cropfarm.ICrop;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class CropDefault
implements ICrop {
    @Override
    public List<BlockPos> getPositionsToHarvest(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() instanceof IGrowable && !((IGrowable)state.func_177230_c()).func_176473_a(world, pos, state, world.field_72995_K)) {
            return Collections.singletonList(pos);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean canBeFertilized(IBlockState state, World world, BlockPos pos) {
        if (!(state.func_177230_c() instanceof IGrowable)) {
            return false;
        }
        IGrowable growable = (IGrowable)state.func_177230_c();
        return growable.func_176473_a(world, pos, state, world.field_72995_K) && growable.func_180670_a(world, world.field_73012_v, pos, state);
    }

    @Override
    public boolean harvest(World world, IBlockState state, BlockPos pos, int fortune, IItemHandler inventory) {
        NonNullList stacks = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)stacks, world, pos, state, fortune);
        if (!InventoryTools.canInventoryHold(inventory, (List<ItemStack>)stacks)) {
            return false;
        }
        if (!this.breakCrop(world, pos, state)) {
            return false;
        }
        ItemStack plantable = InventoryTools.removeItem((NonNullList<ItemStack>)stacks, i -> i.func_77973_b() instanceof IPlantable, 1);
        if (!plantable.func_190926_b()) {
            BlockTools.placeItemBlock(plantable, world, pos, EnumFacing.UP);
        }
        InventoryTools.insertOrDropItems(inventory, (List<ItemStack>)stacks, world, pos);
        return true;
    }

    protected boolean breakCrop(World world, BlockPos pos, IBlockState state) {
        return BlockTools.breakBlockNoDrops(world, pos, state);
    }

    protected void getDrops(NonNullList<ItemStack> stacks, World world, BlockPos pos, IBlockState state, int fortune) {
        state.func_177230_c().getDrops(stacks, (IBlockAccess)world, pos, state, fortune);
    }

    @Override
    public boolean matches(IBlockState state) {
        return true;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isPlantable(ItemStack stack) {
        return stack.func_77973_b() instanceof IPlantable || this.isPlantableItemBlock(stack) || this.isPlantableSpecialItemBlock(stack);
    }

    private boolean isPlantableSpecialItemBlock(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlockSpecial && ((ItemBlockSpecial)stack.func_77973_b()).getBlock() instanceof IPlantable;
    }

    private boolean isPlantableItemBlock(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof IPlantable;
    }
}

