/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite.cropfarm;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.automation.tile.worksite.cropfarm.CropDefault;
import net.shadowmage.ancientwarfare.core.util.parsing.BlockStateMatcher;

public class CropTall
extends CropDefault {
    private int height = 1;
    private BlockStateMatcher stateMatcher;

    public CropTall(BlockStateMatcher stateMatcher, int height) {
        this.stateMatcher = stateMatcher;
        this.height = height;
    }

    @Override
    public List<BlockPos> getPositionsToHarvest(World world, BlockPos pos, IBlockState state) {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        this.applyToCrop(world, pos, (p, s) -> {
            if (s.func_177230_c() instanceof IGrowable && !((IGrowable)s.func_177230_c()).func_176473_a(world, p, s, world.field_72995_K)) {
                ret.add((BlockPos)p);
            }
            return true;
        });
        return ret;
    }

    @Override
    protected boolean breakCrop(World world, BlockPos pos, IBlockState state) {
        return this.applyToCrop(world, pos, (p, s) -> super.breakCrop(world, (BlockPos)p, (IBlockState)s));
    }

    @Override
    protected void getDrops(NonNullList<ItemStack> stacks, World world, BlockPos pos, IBlockState state, int fortune) {
        this.applyToCrop(world, pos, (p, s) -> {
            super.getDrops(stacks, world, (BlockPos)p, (IBlockState)s, fortune);
            return true;
        });
    }

    private boolean applyToCrop(World world, BlockPos pos, BiFunction<BlockPos, IBlockState, Boolean> applyToBlock) {
        boolean ret = true;
        BlockPos curPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + (this.height - 1), pos.func_177952_p());
        while (curPos.func_177956_o() >= pos.func_177956_o()) {
            IBlockState curState = world.func_180495_p(curPos);
            ret = ret && applyToBlock.apply(curPos, curState) != false;
            curPos = curPos.func_177977_b();
        }
        return ret;
    }

    @Override
    public boolean matches(IBlockState state) {
        return this.stateMatcher.test(state);
    }
}

