/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.Branch;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ITree;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ITreeScanner;

public class ChorusScanner
implements ITreeScanner {
    @Override
    public ITree scanTree(World world, BlockPos pos, BlockPos minPos, BlockPos maxPos) {
        Branch branch = new Branch();
        HashSet<BlockPos> scannedPositions = new HashSet<BlockPos>();
        this.scanBranchHarvestableBlocks(scannedPositions, branch, world, pos, EnumFacing.DOWN);
        return branch;
    }

    private void scanBranchHarvestableBlocks(Set<BlockPos> scannedPositions, Branch parentBranch, World world, BlockPos startPos, EnumFacing avoidDirection) {
        boolean continueSearch;
        if (!scannedPositions.add(startPos)) {
            return;
        }
        BlockPos currentPos = startPos;
        EnumFacing avoidNext = avoidDirection;
        Branch childBranch = new Branch();
        parentBranch.addChildBranch(childBranch);
        do {
            continueSearch = false;
            childBranch.addTrunkPos(currentPos);
            IBlockState state = world.func_180495_p(currentPos);
            if (state.func_177230_c() == Blocks.field_185766_cS) {
                if ((Integer)state.func_177229_b((IProperty)BlockChorusFlower.field_185607_a) == 5) {
                    childBranch.setMature();
                }
                return;
            }
            List<EnumFacing> connectedSides = this.getConnectedSides(avoidNext, world, currentPos);
            if (connectedSides.size() == 1) {
                continueSearch = true;
                EnumFacing nextFacing = connectedSides.get(0);
                if (!scannedPositions.add(currentPos = currentPos.func_177972_a(nextFacing))) {
                    return;
                }
                avoidNext = nextFacing.func_176734_d();
                continue;
            }
            if (connectedSides.size() <= 1) continue;
            this.scanConnectedBranchsBlocks(scannedPositions, childBranch, world, currentPos, connectedSides);
            childBranch.updateMature();
            return;
        } while (continueSearch);
        childBranch.setMature();
    }

    private void scanConnectedBranchsBlocks(Set<BlockPos> scannedPositions, Branch parentBranch, World world, BlockPos currentPos, List<EnumFacing> connectedSides) {
        for (EnumFacing side : connectedSides) {
            this.scanBranchHarvestableBlocks(scannedPositions, parentBranch, world, currentPos.func_177972_a(side), side.func_176734_d());
        }
    }

    private List<EnumFacing> getConnectedSides(EnumFacing avoidDirection, World world, BlockPos pos) {
        ArrayList<EnumFacing> connectedSides = new ArrayList<EnumFacing>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing == EnumFacing.DOWN || facing == avoidDirection || !this.plantIsConnectedOnSide(world, pos, facing)) continue;
            connectedSides.add(facing);
        }
        return connectedSides;
    }

    private boolean plantIsConnectedOnSide(World world, BlockPos pos, EnumFacing side) {
        Block block = world.func_180495_p(pos.func_177972_a(side)).func_177230_c();
        return block == Blocks.field_185765_cR || block == Blocks.field_185766_cS;
    }

    @Override
    public boolean matches(IBlockState state) {
        return state.func_177230_c() == Blocks.field_185765_cR;
    }
}

