/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.block;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;

public class BlockRotationHandler {
    public static EnumFacing getFaceForPlacement(EntityLivingBase entity, IRotatableBlock block, EnumFacing sideHit) {
        if (block.getRotationType() == RotationType.NONE) {
            return EnumFacing.NORTH;
        }
        EnumFacing facing = entity.func_174811_aO();
        if (block.getRotationType() == RotationType.SIX_WAY && sideHit.func_176740_k() == EnumFacing.Axis.Y) {
            facing = sideHit.func_176734_d();
        }
        if (block.invertFacing()) {
            facing = facing.func_176734_d();
        }
        return facing;
    }

    public static enum RelativeSide {
        TOP("guistrings.inventory.side.top"),
        BOTTOM("guistrings.inventory.side.bottom"),
        FRONT("guistrings.inventory.side.front"),
        REAR("guistrings.inventory.side.rear"),
        LEFT("guistrings.inventory.side.left"),
        RIGHT("guistrings.inventory.side.right"),
        ANY_SIDE("guistrings.inventory.side.all_sides"),
        NONE("guistrings.inventory.side.none");

        private static final int DOWN;
        private static final int UP;
        private static final int NORTH;
        private static final int SOUTH;
        private static final int WEST;
        private static final int EAST;
        protected static final RelativeSide[][] sixWayMap;
        protected static final RelativeSide[][] fourWayMap;
        private String key;

        private RelativeSide(String key) {
            this.key = key;
        }

        public String getTranslationKey() {
            return this.key;
        }

        public static RelativeSide getSideViewed(RotationType t, EnumFacing facing, @Nullable EnumFacing side) {
            if (side != null) {
                if (t == RotationType.FOUR_WAY) {
                    return fourWayMap[side.ordinal()][facing.ordinal()];
                }
                if (t == RotationType.SIX_WAY) {
                    return sixWayMap[side.ordinal()][facing.ordinal()];
                }
            }
            return ANY_SIDE;
        }

        @Nullable
        public static EnumFacing getMCSideToAccess(RotationType t, EnumFacing facing, RelativeSide access) {
            RelativeSide[][] map = t == RotationType.FOUR_WAY ? fourWayMap : sixWayMap;
            for (int x = 0; x < map.length; ++x) {
                if (map[x][facing.ordinal()] != access) continue;
                return EnumFacing.field_82609_l[x];
            }
            return null;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            DOWN = EnumFacing.DOWN.ordinal();
            UP = EnumFacing.UP.ordinal();
            NORTH = EnumFacing.NORTH.ordinal();
            SOUTH = EnumFacing.SOUTH.ordinal();
            WEST = EnumFacing.WEST.ordinal();
            EAST = EnumFacing.EAST.ordinal();
            sixWayMap = new RelativeSide[6][6];
            fourWayMap = new RelativeSide[6][6];
            RelativeSide.sixWayMap[RelativeSide.DOWN][RelativeSide.DOWN] = TOP;
            RelativeSide.sixWayMap[RelativeSide.DOWN][RelativeSide.UP] = BOTTOM;
            RelativeSide.sixWayMap[RelativeSide.DOWN][RelativeSide.NORTH] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.DOWN][RelativeSide.SOUTH] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.DOWN][RelativeSide.WEST] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.DOWN][RelativeSide.EAST] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.UP][RelativeSide.DOWN] = BOTTOM;
            RelativeSide.sixWayMap[RelativeSide.UP][RelativeSide.UP] = TOP;
            RelativeSide.sixWayMap[RelativeSide.UP][RelativeSide.NORTH] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.UP][RelativeSide.SOUTH] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.UP][RelativeSide.WEST] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.UP][RelativeSide.EAST] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.NORTH][RelativeSide.DOWN] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.NORTH][RelativeSide.UP] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.NORTH][RelativeSide.NORTH] = TOP;
            RelativeSide.sixWayMap[RelativeSide.NORTH][RelativeSide.SOUTH] = BOTTOM;
            RelativeSide.sixWayMap[RelativeSide.NORTH][RelativeSide.WEST] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.NORTH][RelativeSide.EAST] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.SOUTH][RelativeSide.DOWN] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.SOUTH][RelativeSide.UP] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.SOUTH][RelativeSide.NORTH] = BOTTOM;
            RelativeSide.sixWayMap[RelativeSide.SOUTH][RelativeSide.SOUTH] = TOP;
            RelativeSide.sixWayMap[RelativeSide.SOUTH][RelativeSide.WEST] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.SOUTH][RelativeSide.EAST] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.WEST][RelativeSide.DOWN] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.WEST][RelativeSide.UP] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.WEST][RelativeSide.NORTH] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.WEST][RelativeSide.SOUTH] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.WEST][RelativeSide.WEST] = TOP;
            RelativeSide.sixWayMap[RelativeSide.WEST][RelativeSide.EAST] = BOTTOM;
            RelativeSide.sixWayMap[RelativeSide.EAST][RelativeSide.DOWN] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.EAST][RelativeSide.UP] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.EAST][RelativeSide.NORTH] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.EAST][RelativeSide.SOUTH] = ANY_SIDE;
            RelativeSide.sixWayMap[RelativeSide.EAST][RelativeSide.WEST] = BOTTOM;
            RelativeSide.sixWayMap[RelativeSide.EAST][RelativeSide.EAST] = TOP;
            RelativeSide.fourWayMap[RelativeSide.DOWN][RelativeSide.DOWN] = ANY_SIDE;
            RelativeSide.fourWayMap[RelativeSide.DOWN][RelativeSide.UP] = ANY_SIDE;
            RelativeSide.fourWayMap[RelativeSide.DOWN][RelativeSide.NORTH] = BOTTOM;
            RelativeSide.fourWayMap[RelativeSide.DOWN][RelativeSide.SOUTH] = BOTTOM;
            RelativeSide.fourWayMap[RelativeSide.DOWN][RelativeSide.WEST] = BOTTOM;
            RelativeSide.fourWayMap[RelativeSide.DOWN][RelativeSide.EAST] = BOTTOM;
            RelativeSide.fourWayMap[RelativeSide.UP][RelativeSide.DOWN] = ANY_SIDE;
            RelativeSide.fourWayMap[RelativeSide.UP][RelativeSide.UP] = ANY_SIDE;
            RelativeSide.fourWayMap[RelativeSide.UP][RelativeSide.NORTH] = TOP;
            RelativeSide.fourWayMap[RelativeSide.UP][RelativeSide.SOUTH] = TOP;
            RelativeSide.fourWayMap[RelativeSide.UP][RelativeSide.WEST] = TOP;
            RelativeSide.fourWayMap[RelativeSide.UP][RelativeSide.EAST] = TOP;
            RelativeSide.fourWayMap[RelativeSide.NORTH][RelativeSide.DOWN] = ANY_SIDE;
            RelativeSide.fourWayMap[RelativeSide.NORTH][RelativeSide.UP] = ANY_SIDE;
            RelativeSide.fourWayMap[RelativeSide.NORTH][RelativeSide.NORTH] = FRONT;
            RelativeSide.fourWayMap[RelativeSide.NORTH][RelativeSide.SOUTH] = REAR;
            RelativeSide.fourWayMap[RelativeSide.NORTH][RelativeSide.WEST] = RIGHT;
            RelativeSide.fourWayMap[RelativeSide.NORTH][RelativeSide.EAST] = LEFT;
            RelativeSide.fourWayMap[RelativeSide.SOUTH][RelativeSide.DOWN] = ANY_SIDE;
            RelativeSide.fourWayMap[RelativeSide.SOUTH][RelativeSide.UP] = ANY_SIDE;
            RelativeSide.fourWayMap[RelativeSide.SOUTH][RelativeSide.NORTH] = REAR;
            RelativeSide.fourWayMap[RelativeSide.SOUTH][RelativeSide.SOUTH] = FRONT;
            RelativeSide.fourWayMap[RelativeSide.SOUTH][RelativeSide.WEST] = LEFT;
            RelativeSide.fourWayMap[RelativeSide.SOUTH][RelativeSide.EAST] = RIGHT;
            RelativeSide.fourWayMap[RelativeSide.WEST][RelativeSide.DOWN] = ANY_SIDE;
            RelativeSide.fourWayMap[RelativeSide.WEST][RelativeSide.UP] = ANY_SIDE;
            RelativeSide.fourWayMap[RelativeSide.WEST][RelativeSide.NORTH] = LEFT;
            RelativeSide.fourWayMap[RelativeSide.WEST][RelativeSide.SOUTH] = RIGHT;
            RelativeSide.fourWayMap[RelativeSide.WEST][RelativeSide.WEST] = FRONT;
            RelativeSide.fourWayMap[RelativeSide.WEST][RelativeSide.EAST] = REAR;
            RelativeSide.fourWayMap[RelativeSide.EAST][RelativeSide.DOWN] = ANY_SIDE;
            RelativeSide.fourWayMap[RelativeSide.EAST][RelativeSide.UP] = ANY_SIDE;
            RelativeSide.fourWayMap[RelativeSide.EAST][RelativeSide.NORTH] = RIGHT;
            RelativeSide.fourWayMap[RelativeSide.EAST][RelativeSide.SOUTH] = LEFT;
            RelativeSide.fourWayMap[RelativeSide.EAST][RelativeSide.WEST] = REAR;
            RelativeSide.fourWayMap[RelativeSide.EAST][RelativeSide.EAST] = FRONT;
        }
    }

    public static enum RotationType {
        FOUR_WAY(EnumSet.of(RelativeSide.TOP, new RelativeSide[]{RelativeSide.BOTTOM, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.FRONT, RelativeSide.REAR})),
        SIX_WAY(EnumSet.of(RelativeSide.TOP, RelativeSide.BOTTOM, RelativeSide.ANY_SIDE)),
        NONE(EnumSet.of(RelativeSide.TOP, new RelativeSide[]{RelativeSide.BOTTOM, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.FRONT, RelativeSide.REAR}));

        EnumSet<RelativeSide> validSides;

        private RotationType(EnumSet<RelativeSide> sides) {
            this.validSides = sides;
        }

        public Set<RelativeSide> getValidSides() {
            return this.validSides;
        }
    }

    public static interface IRotatableTile {
        public EnumFacing getPrimaryFacing();

        public void setPrimaryFacing(EnumFacing var1);
    }

    public static interface IRotatableBlock {
        public RotationType getRotationType();

        public boolean invertFacing();
    }
}

