/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.command;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.core.command.ISubCommand;

public abstract class ParentCommand
implements ISubCommand {
    private Map<String, ISubCommand> subCommands = new TreeMap<String, ISubCommand>();
    private boolean isRoot;

    protected ParentCommand() {
        this(false);
    }

    ParentCommand(boolean isRoot) {
        this.isRoot = isRoot;
    }

    protected void registerSubCommand(ISubCommand subCommand) {
        this.subCommands.put(subCommand.getName().toLowerCase(Locale.ENGLISH), subCommand);
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ISubCommand subCommand;
        if (args.length == 0 || !this.subCommands.containsKey(args[0].toLowerCase())) {
            throw new WrongUsageException(this.getUsage(sender), new Object[0]);
        }
        String[] subArgs = this.getSubArgs(args);
        if (subArgs.length < (subCommand = this.getSubCommand(args[0])).getMinArgs() || subArgs.length > subCommand.getMaxArgs()) {
            throw new WrongUsageException(this.getUsage(sender), new Object[0]);
        }
        subCommand.execute(server, sender, subArgs);
    }

    @Override
    public String getUsage(ICommandSender sender) {
        return (this.isRoot ? "/" : "") + this.getName() + " < " + this.subCommands.values().stream().map(sc -> sc.getUsage(sender)).collect(Collectors.joining(" | ")) + " >";
    }

    private ISubCommand getSubCommand(String arg) {
        return this.subCommands.get(arg.toLowerCase());
    }

    private String[] getSubArgs(String[] args) {
        String[] subArgs = new String[args.length - 1];
        System.arraycopy(args, 1, subArgs, 0, args.length - 1);
        return subArgs;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return this.getListOfSubcommandsMatchingString(args[0]);
        }
        if (args.length > 1) {
            String[] subArgs = this.getSubArgs(args);
            ISubCommand subCommand = this.getSubCommand(args[0]);
            return subCommand.getTabCompletions(server, sender, subArgs, targetPos);
        }
        return Collections.emptyList();
    }

    private List<String> getListOfSubcommandsMatchingString(String commandName) {
        return this.subCommands.keySet().stream().filter(scName -> scName.startsWith(commandName)).collect(Collectors.toList());
    }

    @Override
    public int getMaxArgs() {
        return 1 + this.subCommands.values().stream().map(ISubCommand::getMaxArgs).max(Comparator.naturalOrder()).orElse(0);
    }
}

