/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class CompositeItemSlots
extends CompositeScrolled {
    private static RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
    private List<ItemSlot> itemSlots = new ArrayList<ItemSlot>();
    ITooltipRenderer render;

    public CompositeItemSlots(GuiContainerBase gui, int topLeftX, int topLeftY, int width, int height, ITooltipRenderer render) {
        super(gui, topLeftX, topLeftY, width, height);
        this.render = render;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            mouseX = Integer.MIN_VALUE;
            mouseY = Integer.MIN_VALUE;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(backgroundTextureLocation);
        RenderTools.renderQuarteredTexture(256, 256, 0, 0, 256, 240, this.renderX, this.renderY, this.width, this.height);
        this.setViewport();
        for (GuiElement element : this.elements) {
            if (element.renderY > this.renderY + this.height || element.renderY + element.height < this.renderY || element.renderX > this.renderX + this.width || element.renderX + element.width < this.renderX) continue;
            if (element instanceof ItemSlot) {
                this.itemSlots.add((ItemSlot)element);
                continue;
            }
            element.render(mouseX, mouseY, partialTick);
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(widgetTexture1);
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (ItemSlot slot : this.itemSlots) {
            this.renderSlotBackground(slot);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        RenderHelper.func_74520_c();
        CompositeItemSlots.itemRender.field_77023_b = 10.0f;
        for (ItemSlot slot : this.itemSlots) {
            this.renderItemStack(slot);
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        for (ItemSlot slot : this.itemSlots) {
            this.renderOverlay(slot);
        }
        for (ItemSlot slot : this.itemSlots) {
            this.renderSlotHighlight(slot, mouseX, mouseY);
        }
        this.itemSlots.clear();
        this.popViewport();
        GlStateManager.func_179098_w();
        this.scrollbar.render(mouseX, mouseY, partialTick);
    }

    private void renderSlotBackground(ItemSlot slot) {
        if (slot.visible && slot.renderSlotBackground) {
            RenderTools.renderQuarteredTexture(256, 256, 152, 120, 18, 18, slot.renderX, slot.renderY, slot.width, slot.height);
        }
    }

    private void renderSlotHighlight(ItemSlot slot, int mouseX, int mouseY) {
        ItemStack stack = slot.getStack();
        if (stack.func_190926_b() || !slot.visible) {
            return;
        }
        if (slot.highlightOnMouseOver && slot.isMouseOverElement(mouseX, mouseY)) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_187447_r((int)7);
            GL11.glVertex2f((float)slot.renderX, (float)slot.renderY);
            GL11.glVertex2f((float)slot.renderX, (float)((float)slot.renderY + (float)slot.height));
            GL11.glVertex2f((float)((float)slot.renderX + (float)slot.width), (float)((float)slot.renderY + (float)slot.height));
            GL11.glVertex2d((double)((float)slot.renderX + (float)slot.width), (double)slot.renderY);
            GlStateManager.func_187437_J();
            GlStateManager.func_179084_k();
            if (slot.renderTooltip && !slot.getStack().func_190926_b() && this.render != null) {
                if (slot.tooltip != null) {
                    this.render.handleElementTooltipRender(slot.tooltip, mouseX, mouseY);
                } else {
                    this.render.handleItemStackTooltipRender(slot.getStack(), mouseX, mouseY);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179126_j();
        }
    }

    private void renderOverlay(ItemSlot slot) {
        ItemStack stack = slot.getStack();
        if (stack.func_190926_b() || !slot.visible) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = mc.field_71466_p;
        }
        itemRender.func_180453_a(font, stack, slot.renderX + 1, slot.renderY + 1, "");
        if (slot.renderItemQuantity && slot.getStack().func_190916_E() > 1) {
            slot.renderStackSize(slot.renderX + 1, slot.renderY + 1, stack.func_190916_E(), font);
        }
    }

    private void renderItemStack(ItemSlot slot) {
        ItemStack stack = slot.getStack();
        if (stack.func_190926_b() || !slot.visible) {
            return;
        }
        itemRender.func_180450_b(stack, slot.renderX + 1, slot.renderY + 1);
    }
}

