/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Composite;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Scrollbar;
import net.shadowmage.ancientwarfare.core.interfaces.IScrollableCallback;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;
import net.shadowmage.ancientwarfare.core.util.RenderTools;

@SideOnly(value=Side.CLIENT)
public class CompositeScrolled
extends Composite
implements IScrollableCallback {
    protected Scrollbar scrollbar;
    private int currentTop = 0;

    public CompositeScrolled(GuiContainerBase gui, int topLeftX, int topLeftY, int width, int height) {
        super(gui, topLeftX, topLeftY, width, height);
        this.scrollbar = new Scrollbar(width - 12, 0, 12, height, this);
    }

    @Override
    public void onScrolled(int newTop) {
        this.currentTop = newTop;
        this.updateElementPositions();
    }

    @Override
    protected void updateElementPositions() {
        this.scrollbar.updateGuiPosition(this.renderX, this.renderY);
        for (GuiElement element : this.elements) {
            element.updateGuiPosition(this.renderX, this.renderY - this.currentTop);
        }
    }

    public void setAreaSize(int height) {
        this.scrollbar.setAreaSize(height);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            mouseX = Integer.MIN_VALUE;
            mouseY = Integer.MIN_VALUE;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(backgroundTextureLocation);
        RenderTools.renderQuarteredTexture(256, 256, 0, 0, 256, 240, this.renderX, this.renderY, this.width, this.height);
        this.setViewport();
        for (GuiElement element : this.elements) {
            if (element.renderY > this.renderY + this.height || element.renderY + element.height < this.renderY || element.renderX > this.renderX + this.width || element.renderX + element.width < this.renderX) continue;
            element.render(mouseX, mouseY, partialTick);
        }
        this.popViewport();
        this.scrollbar.render(mouseX, mouseY, partialTick);
    }

    @Override
    public void postRender(int mouseX, int mouseY, float partialTick, long tick, ITooltipRenderer rend) {
        for (GuiElement element : this.elements) {
            element.postRender(mouseX, mouseY, partialTick, tick, rend);
        }
    }

    @Override
    protected void addDefaultListeners() {
        this.addNewListener(new Listener(-1){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if ((evt.type & 3) != 0) {
                    for (GuiElement element : CompositeScrolled.this.elements) {
                        element.handleKeyboardInput(evt);
                    }
                } else if ((evt.type & 0x3C) != 0) {
                    if (CompositeScrolled.this.isMouseOverElement(evt.mx, evt.my)) {
                        boolean overElement = false;
                        CompositeScrolled.this.scrollbar.handleMouseInput(evt);
                        for (GuiElement element : CompositeScrolled.this.elements) {
                            if (element.isMouseOverElement(evt.mx, evt.my)) {
                                overElement = evt.mw == 0 || element.scrollInput;
                            }
                            element.handleMouseInput(evt);
                        }
                        if (!overElement && !CompositeScrolled.this.scrollbar.isMouseOverElement(evt.mx, evt.my) && evt.mw != 0) {
                            CompositeScrolled.this.scrollbar.handleMouseScroll(evt);
                        }
                    } else {
                        if (evt.type == 4) {
                            for (GuiElement element : CompositeScrolled.this.elements) {
                                element.handleMouseInput(evt);
                                element.setSelected(false);
                            }
                        }
                        CompositeScrolled.this.scrollbar.dragging = false;
                        CompositeScrolled.this.scrollbar.pressed = false;
                    }
                }
                return true;
            }
        });
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        int h = this.scrollbar.totalAreaSize;
        this.elements.remove(this.scrollbar);
        this.scrollbar = new Scrollbar(width - 12, 0, 12, height, this);
        this.scrollbar.setAreaSize(h);
    }
}

