/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.util.RenderTools;

public abstract class ItemToggleButton
extends GuiElement {
    private static final RenderItem RENDER_ITEM = Minecraft.func_71410_x().func_175599_af();
    private final ItemStack item;
    private boolean pressed = false;
    private boolean toggled = false;

    public ItemToggleButton(int topLeftX, int topLeftY, ItemStack item) {
        this(topLeftX, topLeftY, item, true);
    }

    public ItemToggleButton(int topLeftX, int topLeftY, ItemStack item, final boolean canClickUntoggle) {
        super(topLeftX, topLeftY, 20, 20);
        this.item = item;
        this.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (ItemToggleButton.this.pressed && ItemToggleButton.this.enabled && ItemToggleButton.this.visible && ItemToggleButton.this.isMouseOverElement(evt.mx, evt.my)) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    ItemToggleButton.this.onPressed(evt.mButton);
                }
                ItemToggleButton.this.pressed = false;
                return true;
            }
        });
        this.addNewListener(new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (ItemToggleButton.this.enabled && ItemToggleButton.this.visible && ItemToggleButton.this.isMouseOverElement(evt.mx, evt.my) && (canClickUntoggle || !ItemToggleButton.this.toggled)) {
                    ItemToggleButton.this.pressed = true;
                    ItemToggleButton.this.toggled = !ItemToggleButton.this.toggled;
                }
                return true;
            }
        });
    }

    protected abstract void onPressed(int var1);

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(widgetTexture2);
            int textureSize = 256;
            int startX = 0;
            int startY = 40;
            if (this.enabled) {
                startY = this.isMouseOverElement(mouseX, mouseY) ? (this.toggled ? 160 : 80) : (this.toggled ? 120 : 40);
            }
            int usedWidth = 256;
            int usedHeight = 40;
            RenderTools.renderQuarteredTexture(textureSize, textureSize, startX, startY, usedWidth, usedHeight, this.renderX, this.renderY, this.width, this.height);
            GlStateManager.func_179091_B();
            GlStateManager.func_179126_j();
            RenderHelper.func_74520_c();
            RENDER_ITEM.func_180450_b(this.item, this.renderX + 2, this.renderY + 2);
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
        }
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
    }
}

