/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.util.RenderTools;

@SideOnly(value=Side.CLIENT)
public class TexturedButton
extends GuiElement {
    private final TextureSet textureSet;
    private boolean pressed = false;

    public TexturedButton(int topLeftX, int topLeftY, TextureSet textureSet) {
        super(topLeftX, topLeftY, textureSet.getWidth(), textureSet.getHeight());
        this.textureSet = textureSet;
        this.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (TexturedButton.this.pressed && TexturedButton.this.enabled && TexturedButton.this.visible && TexturedButton.this.isMouseOverElement(evt.mx, evt.my)) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    TexturedButton.this.onPressed(evt.mButton);
                }
                TexturedButton.this.pressed = false;
                return true;
            }
        });
        this.addNewListener(new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (TexturedButton.this.enabled && TexturedButton.this.visible && TexturedButton.this.isMouseOverElement(evt.mx, evt.my)) {
                    TexturedButton.this.pressed = true;
                }
                return true;
            }
        });
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(widgetTexture1);
            int textureSize = 256;
            boolean mouseOver = this.isMouseOverElement(mouseX, mouseY);
            Texture texture = this.enabled ? (mouseOver ? this.textureSet.getHighlighted() : this.textureSet.getEnabled()) : this.textureSet.getDisabled();
            RenderTools.renderQuarteredTexture(textureSize, textureSize, texture.getU(), texture.getV(), this.textureSet.getWidth(), this.textureSet.getHeight(), this.renderX, this.renderY, this.width, this.height);
        }
    }

    protected void onPressed() {
    }

    protected void onPressed(int mButton) {
        this.onPressed();
    }

    private static enum Texture {
        LEFT_ARROW_DISABLED(170, 121),
        LEFT_ARROW_ENABLED(190, 121),
        LEFT_ARROW_HIGHLIGHTED(210, 121),
        RIGHT_ARROW_DISABLED(180, 121),
        RIGHT_ARROW_ENABLED(200, 121),
        RIGHT_ARROW_HIGHLIGHTED(220, 121);

        private final int u;
        private final int v;

        public int getU() {
            return this.u;
        }

        public int getV() {
            return this.v;
        }

        private Texture(int u, int v) {
            this.u = u;
            this.v = v;
        }
    }

    public static enum TextureSet {
        LEFT_ARROW(Texture.LEFT_ARROW_DISABLED, Texture.LEFT_ARROW_ENABLED, Texture.LEFT_ARROW_HIGHLIGHTED, 10, 16),
        RIGHT_ARROW(Texture.RIGHT_ARROW_DISABLED, Texture.RIGHT_ARROW_ENABLED, Texture.RIGHT_ARROW_HIGHLIGHTED, 10, 16);

        private final Texture disabled;
        private final Texture enabled;
        private final Texture highlighted;
        private final int width;
        private final int height;

        public Texture getDisabled() {
            return this.disabled;
        }

        public Texture getEnabled() {
            return this.enabled;
        }

        public Texture getHighlighted() {
            return this.highlighted;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        private TextureSet(Texture disabled, Texture enabled, Texture highlighted, int width, int height) {
            this.disabled = disabled;
            this.enabled = enabled;
            this.highlighted = highlighted;
            this.width = width;
            this.height = height;
        }
    }
}

