/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.init;

import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.util.FileUtils;
import org.apache.commons.io.FilenameUtils;

@Mod.EventBusSubscriber(modid="ancientwarfare")
public class AWCoreLoot {
    private static final String CONDITIONS_PROPERTY = "conditions";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPoolSerializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntrySerializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    private static final String CHESTS_DIRECTORY = "assets/ancientwarfare/loot_tables/chests";
    private static final Map<String, Path> injectTables = new HashMap<String, Path>();
    private static final String INJECT_FOLDER = "inject";
    private static final String COMPAT_FOLDER = "compat";
    private static final Field POOLS = ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c");
    private static final Field LOOT_ENTRIES = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");

    private AWCoreLoot() {
    }

    public static void init() {
        AWCoreLoot.loadChestLootTables();
    }

    private static void loadChestLootTables() {
        FileUtils.findFiles(Loader.instance().activeModContainer().getSource(), CHESTS_DIRECTORY, (root, file) -> {
            String extension = FilenameUtils.getExtension((String)file.toString());
            if (!extension.equals("json")) {
                return;
            }
            Path relative = root.relativize((Path)file);
            if (relative.getName(0).toString().equals(COMPAT_FOLDER) && relative.getNameCount() > 1) {
                String modName = relative.getName(1).toString();
                if (!Loader.isModLoaded((String)modName)) {
                    return;
                }
                if (relative.getNameCount() > 2 && relative.getName(2).toString().equals(INJECT_FOLDER)) {
                    String lootTableName = AWCoreLoot.convertToRegistryName(root.resolve(COMPAT_FOLDER).resolve(modName).resolve(INJECT_FOLDER).relativize((Path)file));
                    injectTables.put(lootTableName, (Path)file);
                    return;
                }
                LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientwarfare", AWCoreLoot.convertToRegistryName(relative)));
                return;
            }
            if (relative.getName(0).toString().equals(INJECT_FOLDER)) {
                String lootTableName = AWCoreLoot.convertToRegistryName(root.resolve(INJECT_FOLDER).relativize((Path)file));
                injectTables.put(lootTableName, (Path)file);
                return;
            }
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientwarfare", AWCoreLoot.convertToRegistryName(relative)));
        });
    }

    private static String convertToRegistryName(Path path) {
        return "chests/" + FilenameUtils.removeExtension((String)path.toString()).replaceAll("\\\\", "/");
    }

    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent evt) {
        String resPath = evt.getName().func_110623_a();
        if (injectTables.containsKey(resPath)) {
            String jsonContents;
            String jsonPath = injectTables.get(resPath).toString();
            try {
                File file = new File(jsonPath);
                jsonContents = file.exists() ? Files.toString((File)file, (Charset)StandardCharsets.UTF_8) : Resources.toString((URL)AWCoreLoot.class.getResource(jsonPath), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                AncientWarfareCore.LOG.error("Error reading loot table json {}", (Object)jsonPath, (Object)e);
                return;
            }
            LootTable injectedLootTable = (LootTable)GSON.fromJson(jsonContents, LootTable.class);
            LootTable lootTable = evt.getTable();
            for (LootPool injectedPool : AWCoreLoot.getLootPools(injectedLootTable)) {
                LootPool lootPool = lootTable.getPool(injectedPool.getName());
                if (lootPool != null) {
                    AWCoreLoot.injectEntriesIntoPool(injectedPool, lootPool);
                    continue;
                }
                lootTable.addPool(injectedPool);
            }
        }
    }

    private static void injectEntriesIntoPool(LootPool injectedPool, LootPool lootPool) {
        List<LootEntry> lootEntries = AWCoreLoot.getLootEntries(injectedPool);
        if (lootEntries != null) {
            for (LootEntry entry : lootEntries) {
                lootPool.addEntry(entry);
            }
        }
    }

    private static List<LootPool> getLootPools(LootTable lootTable) {
        try {
            return (List)POOLS.get(lootTable);
        }
        catch (IllegalAccessException e) {
            AncientWarfareCore.LOG.error("Error accessing pools field of LootTable", (Throwable)e);
            return new ArrayList<LootPool>();
        }
    }

    @Nullable
    private static List<LootEntry> getLootEntries(LootPool lootPool) {
        try {
            return (List)LOOT_ENTRIES.get(lootPool);
        }
        catch (IllegalAccessException e) {
            AncientWarfareCore.LOG.error("Error accessing lootEntries field of LootPool", (Throwable)e);
            return new ArrayList<LootEntry>();
        }
    }

    private static class LootEntrySerializer
    implements JsonDeserializer<LootEntry> {
        private LootEntrySerializer() {
        }

        public LootEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)json, (String)"loot item");
            String s = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"type");
            int weight = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"weight", (int)1);
            int quality = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"quality", (int)0);
            LootCondition[] conditions = jsonobject.has(AWCoreLoot.CONDITIONS_PROPERTY) ? (LootCondition[])JsonUtils.func_188174_a((JsonObject)jsonobject, (String)AWCoreLoot.CONDITIONS_PROPERTY, (JsonDeserializationContext)context, LootCondition[].class) : new LootCondition[]{};
            switch (s) {
                case "item": {
                    String name = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
                    Item item = JsonUtils.func_188180_i((JsonObject)jsonobject, (String)"name");
                    LootFunction[] alootfunction = jsonobject.has("functions") ? (LootFunction[])JsonUtils.func_188174_a((JsonObject)jsonobject, (String)"functions", (JsonDeserializationContext)context, LootFunction[].class) : new LootFunction[]{};
                    return new LootEntryItem(item, weight, quality, alootfunction, conditions, name);
                }
                case "loot_table": {
                    String tableName = JsonUtils.func_151206_a((JsonElement)json, (String)"name");
                    ResourceLocation resourcelocation = new ResourceLocation(tableName);
                    return new LootEntryTable(resourcelocation, weight, quality, conditions, tableName);
                }
                case "empty": {
                    return new LootEntryEmpty(weight, quality, conditions, "empty");
                }
            }
            throw new JsonSyntaxException("Unknown loot entry type '" + s + "'");
        }
    }

    private static class LootPoolSerializer
    implements JsonDeserializer<LootPool> {
        private LootPoolSerializer() {
        }

        public LootPool deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)json, (String)"loot pool");
            String name = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
            LootEntry[] alootentry = (LootEntry[])JsonUtils.func_188174_a((JsonObject)jsonobject, (String)"entries", (JsonDeserializationContext)context, LootEntry[].class);
            LootCondition[] alootcondition = (LootCondition[])JsonUtils.func_188177_a((JsonObject)jsonobject, (String)AWCoreLoot.CONDITIONS_PROPERTY, (Object)new LootCondition[0], (JsonDeserializationContext)context, LootCondition[].class);
            RandomValueRange rolls = (RandomValueRange)JsonUtils.func_188177_a((JsonObject)jsonobject, (String)"rolls", (Object)new RandomValueRange(1.0f, 1.0f), (JsonDeserializationContext)context, RandomValueRange.class);
            RandomValueRange bonusRolls = (RandomValueRange)JsonUtils.func_188177_a((JsonObject)jsonobject, (String)"bonus_rolls", (Object)new RandomValueRange(0.0f, 0.0f), (JsonDeserializationContext)context, RandomValueRange.class);
            return new LootPool(alootentry, alootcondition, rolls, bonusRolls, name);
        }
    }
}

