/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.inventory;

import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ItemHashEntry {
    private final NBTTagCompound itemTag;
    private ItemStack cacheStack = ItemStack.field_190927_a;
    private String cachedNameAndTooltip = "";

    public ItemHashEntry(ItemStack item) {
        ItemStack copy = item.func_77946_l();
        copy.func_190920_e(1);
        this.itemTag = copy.func_77955_b(new NBTTagCompound());
    }

    public int hashCode() {
        return this.itemTag.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ItemHashEntry)) {
            return false;
        }
        return this.itemTag.equals((Object)((ItemHashEntry)obj).itemTag);
    }

    public ItemStack getItemStack() {
        if (this.cacheStack.func_190926_b()) {
            this.cacheStack = new ItemStack(this.itemTag.func_74737_b());
        }
        return this.cacheStack;
    }

    @SideOnly(value=Side.CLIENT)
    public String getNameAndTooltip() {
        if (this.cachedNameAndTooltip.isEmpty()) {
            String stackText = this.cacheStack.func_82833_r().toLowerCase() + " ";
            this.cachedNameAndTooltip = stackText = stackText + String.join((CharSequence)" ", this.cacheStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL)).toLowerCase();
        }
        return this.cachedNameAndTooltip;
    }

    public NBTTagCompound writeToNBT() {
        return this.itemTag.func_74737_b();
    }

    public static ItemHashEntry readFromNBT(NBTTagCompound tag) {
        return new ItemHashEntry(new ItemStack(tag));
    }
}

