/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.inventory.ItemHashEntry;

public class ItemQuantityMap {
    private final Map<ItemHashEntry, Integer> map = new HashMap<ItemHashEntry, Integer>();

    public void addAll(ItemQuantityMap incoming) {
        for (ItemHashEntry entry : incoming.map.keySet()) {
            if (this.map.containsKey(entry)) {
                this.map.put(entry, this.map.get(entry) + incoming.getCount(entry));
                continue;
            }
            this.map.put(entry, incoming.map.get(entry));
        }
    }

    public void removeAll(ItemQuantityMap toRemove) {
        for (ItemHashEntry entry : toRemove.map.keySet()) {
            int currentCount = this.map.get(entry);
            int countToRemove = toRemove.map.get(entry);
            if (countToRemove >= currentCount) {
                this.remove(entry);
                continue;
            }
            this.map.put(entry, currentCount - countToRemove);
        }
    }

    public int getCount(ItemHashEntry entry) {
        if (this.map.containsKey(entry)) {
            return this.map.get(entry);
        }
        return 0;
    }

    public int getCount(ItemStack item) {
        return this.getCount(new ItemHashEntry(item));
    }

    public void addCount(ItemStack item, int count) {
        this.addCount(new ItemHashEntry(item), count);
    }

    private void addCount(ItemHashEntry entry, int count) {
        if (!this.map.containsKey(entry)) {
            this.map.put(entry, count);
        } else {
            this.map.put(entry, this.map.get(entry) + count);
        }
    }

    public void decreaseCount(ItemStack item, int count) {
        this.decreaseCount(new ItemHashEntry(item), count);
    }

    private void decreaseCount(ItemHashEntry entry, int count) {
        if (this.map.containsKey(entry)) {
            int itemCount = this.map.get(entry) - count;
            if (itemCount <= 0) {
                this.map.remove(entry);
            } else {
                this.map.put(entry, itemCount);
            }
        }
    }

    public void remove(ItemHashEntry entry) {
        this.map.remove(entry);
    }

    public void put(ItemStack item, int count) {
        this.put(new ItemHashEntry(item), count);
    }

    public void put(ItemHashEntry wrap, int count) {
        this.map.put(wrap, count);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<ItemHashEntry> keySet() {
        return this.map.keySet();
    }

    public boolean contains(ItemHashEntry entry) {
        return this.map.containsKey(entry);
    }

    public boolean contains(ItemStack item) {
        return this.contains(new ItemHashEntry(item));
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.func_191196_a();
        for (Map.Entry<ItemHashEntry, Integer> entry : this.map.entrySet()) {
            ItemStack outStack;
            for (int qty = entry.getValue().intValue(); qty > 0; qty -= outStack.func_190916_E()) {
                outStack.func_190920_e(qty > (outStack = entry.getKey().getItemStack().func_77946_l()).func_77976_d() ? outStack.func_77976_d() : qty);
                items.add((Object)outStack);
            }
        }
        return items;
    }

    public Map<ItemHashEntry, Integer> getItemCounts() {
        return this.map;
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NBTTagCompound entryTag = entryList.func_150305_b(i);
            this.putEntryFromNBT(entryTag);
        }
    }

    public void putEntryFromNBT(NBTTagCompound entryTag) {
        NBTTagCompound itemTag = entryTag.func_74775_l("item");
        ItemHashEntry entry = ItemHashEntry.readFromNBT(itemTag);
        if (!entry.getItemStack().func_190926_b()) {
            int qty = entryTag.func_74762_e("quantity");
            if (qty == 0) {
                this.map.remove(entry);
            } else {
                this.map.put(entry, qty);
            }
        } else {
            AncientWarfareCore.LOG.warn("Unable to read item from NBT into quantity map, probably no longer exists. {}", (Object)itemTag.toString());
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList entryList = new NBTTagList();
        for (ItemHashEntry entry : this.keySet()) {
            entryList.func_74742_a((NBTBase)this.writeEntryToNBT(entry));
        }
        tag.func_74782_a("entryList", (NBTBase)entryList);
        return tag;
    }

    public NBTTagCompound writeEntryToNBT(ItemHashEntry entry) {
        NBTTagCompound entryTag = new NBTTagCompound();
        entryTag.func_74782_a("item", (NBTBase)entry.writeToNBT());
        entryTag.func_74768_a("quantity", this.getCount(entry));
        return entryTag;
    }

    public int getTotalItemCount() {
        return this.map.values().stream().mapToInt(i -> i).sum();
    }
}

