/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public abstract class PacketBase {
    private static HashMap<Integer, Supplier<? extends PacketBase>> packetTypes = new HashMap();
    private static HashMap<Class<? extends PacketBase>, Integer> packetIDs = new HashMap();

    public static <T extends PacketBase> void registerPacketType(int typeNum, Class<T> packetClz, Supplier<T> instantiate) {
        packetTypes.put(typeNum, instantiate);
        packetIDs.put(packetClz, typeNum);
    }

    private void writeHeaderToStream(ByteBuf data) {
        data.writeByte(packetIDs.get(this.getClass()).intValue());
    }

    private static PacketBase readHeaderFromStream(ByteBuf data) {
        byte typeNum = data.readByte();
        if (!packetTypes.containsKey(typeNum)) {
            throw new IllegalArgumentException("Unregistered packet id received - " + typeNum);
        }
        return packetTypes.get(typeNum).get();
    }

    protected abstract void writeToStream(ByteBuf var1);

    protected abstract void readFromStream(ByteBuf var1) throws IOException;

    protected void execute() {
    }

    protected void execute(EntityPlayer player) {
        this.execute();
    }

    static PacketBase readPacket(ByteBuf data) throws IOException {
        PacketBase pkt = PacketBase.readHeaderFromStream(data);
        pkt.readFromStream(data);
        return pkt;
    }

    final FMLProxyPacket getFMLPacket() {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        this.writeHeaderToStream((ByteBuf)buf);
        this.writeToStream((ByteBuf)buf);
        return new FMLProxyPacket(buf, "AWCORE");
    }
}

