/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.interfaces.IEntityPacketHandler;
import net.shadowmage.ancientwarfare.core.network.PacketBase;

public class PacketEntity
extends PacketBase {
    private int entityId;
    public NBTTagCompound packetData = new NBTTagCompound();

    public PacketEntity() {
    }

    public PacketEntity(Entity e) {
        this.entityId = e.func_145782_y();
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        data.writeInt(this.entityId);
        if (this.packetData != null) {
            try (ByteBufOutputStream outputStream = new ByteBufOutputStream(data);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.packetData, (OutputStream)outputStream);
            }
            catch (IOException e) {
                AncientWarfareCore.LOG.error("Error writing entity packet data: ", (Throwable)e);
            }
        }
    }

    @Override
    protected void readFromStream(ByteBuf data) {
        this.entityId = data.readInt();
        try (ByteBufInputStream inputStream = new ByteBufInputStream(data);){
            this.packetData = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        }
        catch (IOException e) {
            AncientWarfareCore.LOG.error("Error reading entity packet data: ", (Throwable)e);
        }
    }

    @Override
    protected void execute(EntityPlayer player) {
        Entity e = player.field_70170_p.func_73045_a(this.entityId);
        if (e instanceof IEntityPacketHandler) {
            ((IEntityPacketHandler)e).handlePacketData(this.packetData);
        }
    }
}

