/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.core.research.ResearchData;
import net.shadowmage.ancientwarfare.core.research.ResearchTracker;

public class PacketResearchInit
extends PacketBase {
    private NBTTagCompound researchDataTag;

    public PacketResearchInit(ResearchData data) {
        this.researchDataTag = new NBTTagCompound();
        data.func_189551_b(this.researchDataTag);
    }

    public PacketResearchInit() {
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        try (ByteBufOutputStream outputStream = new ByteBufOutputStream(data);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.researchDataTag, (OutputStream)outputStream);
        }
        catch (IOException e) {
            AncientWarfareCore.LOG.error("Error writing research packet data: ", (Throwable)e);
        }
    }

    @Override
    protected void readFromStream(ByteBuf data) {
        try (ByteBufInputStream inputStream = new ByteBufInputStream(data);){
            this.researchDataTag = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        }
        catch (IOException e) {
            AncientWarfareCore.LOG.error("Error reading research packet data: ", (Throwable)e);
        }
    }

    @Override
    protected void execute() {
        ResearchTracker.INSTANCE.onClientResearchReceived(this.researchDataTag);
    }
}

