/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.owner;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.shadowmage.ancientwarfare.core.owner.IOwnable;
import net.shadowmage.ancientwarfare.core.owner.TeamViewerRegistry;

@Immutable
public class Owner {
    public static final Owner EMPTY = new Owner();
    private static final String OWNER_NAME_TAG = "ownerName";
    private static final String OWNER_ID_TAG = "ownerId";
    private final UUID uuid;
    private final String name;

    private Owner() {
        this(new UUID(0L, 0L), "");
    }

    private Owner(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public Owner(EntityPlayer player) {
        this(player.func_110124_au(), player.func_70005_c_());
    }

    public Owner(ByteBuf buffer) {
        this(new UUID(buffer.readLong(), buffer.readLong()), ByteBufUtils.readUTF8String((ByteBuf)buffer));
    }

    public Owner(World world, String name) {
        EntityPlayer player = world.func_72924_a(name);
        this.uuid = player != null ? player.func_110124_au() : new UUID(0L, 0L);
        this.name = name;
    }

    public boolean isOwnerOrSameTeamOrFriend(@Nullable Entity entity) {
        if (entity instanceof IOwnable) {
            Owner owner = ((IOwnable)entity).getOwner();
            return this.isOwnerOrSameTeamOrFriend(entity.field_70170_p, owner.getUUID(), owner.getName());
        }
        if (entity instanceof IEntityOwnable && ((IEntityOwnable)entity).func_70902_q() != null) {
            Entity owner = ((IEntityOwnable)entity).func_70902_q();
            return this.isOwnerOrSameTeamOrFriend(entity.field_70170_p, owner.func_110124_au(), owner.func_70005_c_());
        }
        return entity != null && this.isOwnerOrSameTeamOrFriend(entity.field_70170_p, entity.func_110124_au(), entity.func_70005_c_());
    }

    public boolean isOwnerOrSameTeamOrFriend(World world, @Nullable UUID playerId, String playerName) {
        return TeamViewerRegistry.areFriendly(world, this.uuid, playerId, this.name, playerName);
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void serializeToBuffer(ByteBuf buffer) {
        buffer.writeLong(this.uuid.getMostSignificantBits());
        buffer.writeLong(this.uuid.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
    }

    public NBTTagCompound serializeToNBT(NBTTagCompound tag) {
        if (this == EMPTY) {
            return tag;
        }
        tag.func_74778_a(OWNER_NAME_TAG, this.name);
        tag.func_186854_a(OWNER_ID_TAG, this.uuid);
        return tag;
    }

    public static Owner deserializeFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b(OWNER_NAME_TAG)) {
            return new Owner(tag.func_186857_a(OWNER_ID_TAG), tag.func_74779_i(OWNER_NAME_TAG));
        }
        return EMPTY;
    }

    public boolean playerHasCommandPermissions(World world, UUID playerId, String playerName) {
        return this != EMPTY && TeamViewerRegistry.areTeamMates(world, this.uuid, playerId, this.name, playerName);
    }
}

