/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.tile;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.core.block.BlockResearchStation;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.item.ItemResearchBook;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.registry.ResearchRegistry;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;
import net.shadowmage.ancientwarfare.core.research.ResearchTracker;
import net.shadowmage.ancientwarfare.core.tile.TileOwned;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class TileResearchStation
extends TileOwned
implements IWorkSite,
ITorque.ITorqueTile,
IInteractableTile,
BlockRotationHandler.IRotatableTile,
ITickable {
    public static final String ORIENTATION_TAG = "orientation";
    private EnumFacing orientation = EnumFacing.NORTH;
    public final ItemStackHandler bookInventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            IBlockState iblockstate = TileResearchStation.this.field_145850_b.func_180495_p(TileResearchStation.this.field_174879_c);
            TileResearchStation.this.field_145850_b.func_175656_a(TileResearchStation.this.field_174879_c, iblockstate.func_177226_a((IProperty)BlockResearchStation.HAS_BOOK, (Comparable)Boolean.valueOf(TileResearchStation.this.hasBook())));
            TileResearchStation.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return ItemResearchBook.getResearcherName(stack) != null ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    public final ItemStackHandler resourceInventory = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            TileResearchStation.this.func_70296_d();
        }
    };
    private int startCheckDelay = 0;
    private int startCheckDelayMax = 40;
    public boolean useAdjacentInventory;
    public EnumFacing inventoryDirection = EnumFacing.NORTH;
    public EnumFacing inventorySide = EnumFacing.NORTH;
    private double maxEnergyStored = 1600.0;
    private double maxInput = 100.0;
    private double storedEnergy;

    @Override
    public void onBlockBroken(IBlockState state) {
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.bookInventory, this.field_174879_c);
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.resourceInventory, this.field_174879_c);
    }

    public boolean hasBook() {
        return !this.bookInventory.getStackInSlot(0).func_190926_b();
    }

    @Override
    public Set<WorksiteUpgrade> getUpgrades() {
        return EnumSet.noneOf(WorksiteUpgrade.class);
    }

    @Override
    public Set<WorksiteUpgrade> getValidUpgrades() {
        return EnumSet.noneOf(WorksiteUpgrade.class);
    }

    @Override
    public void addUpgrade(WorksiteUpgrade upgrade) {
    }

    @Override
    public void removeUpgrade(WorksiteUpgrade upgrade) {
    }

    @Override
    public float getClientOutputRotation(EnumFacing from, float delta) {
        return 0.0f;
    }

    @Override
    public boolean useOutputRotation(@Nullable EnumFacing from) {
        return false;
    }

    @Override
    public double getMaxTorqueOutput(EnumFacing from) {
        return 0.0;
    }

    @Override
    public boolean canOutputTorque(EnumFacing towards) {
        return false;
    }

    @Override
    public double addTorque(@Nullable EnumFacing from, double energy) {
        if (this.canInputTorque(from)) {
            if (energy + this.getTorqueStored(from) > this.getMaxTorque(from)) {
                energy = this.getMaxTorque(from) - this.getTorqueStored(from);
            }
            if (energy > this.getMaxTorqueInput(from)) {
                energy = this.getMaxTorqueInput(from);
            }
            this.storedEnergy += energy;
            return energy;
        }
        return 0.0;
    }

    @Override
    public double getMaxTorque(@Nullable EnumFacing from) {
        return this.maxEnergyStored;
    }

    @Override
    public double getTorqueStored(@Nullable EnumFacing from) {
        return this.storedEnergy;
    }

    @Override
    public double getMaxTorqueInput(@Nullable EnumFacing from) {
        return this.maxInput;
    }

    @Override
    public boolean canInputTorque(EnumFacing from) {
        return true;
    }

    public String getCrafterName() {
        return ItemResearchBook.getResearcherName(this.bookInventory.getStackInSlot(0));
    }

    public void func_73660_a() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        String name = this.getCrafterName();
        if (name == null) {
            return;
        }
        Optional<String> goal = ResearchTracker.INSTANCE.getCurrentGoal(this.field_145850_b, name);
        boolean started = goal.isPresent();
        if (started && this.storedEnergy >= AWCoreStatics.energyPerResearchUnit) {
            this.workTick(name, goal.get(), 1);
        } else if (!started) {
            --this.startCheckDelay;
            if (this.startCheckDelay <= 0) {
                this.tryStartNextResearch(name);
            }
        }
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        tag.func_74768_a(ORIENTATION_TAG, this.orientation.ordinal());
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.orientation = EnumFacing.field_82609_l[tag.func_74762_e(ORIENTATION_TAG)];
        BlockTools.notifyBlockUpdate(this);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.bookInventory.deserializeNBT(tag.func_74775_l("bookInventory"));
        this.resourceInventory.deserializeNBT(tag.func_74775_l("resourceInventory"));
        this.useAdjacentInventory = tag.func_74767_n("useAdjacentInventory");
        this.storedEnergy = tag.func_74769_h("storedEnergy");
        if (tag.func_74764_b(ORIENTATION_TAG)) {
            this.setPrimaryFacing(EnumFacing.field_82609_l[tag.func_74762_e(ORIENTATION_TAG)]);
        }
        this.inventoryDirection = EnumFacing.field_82609_l[tag.func_74762_e("inventoryDirection")];
        this.inventorySide = EnumFacing.field_82609_l[tag.func_74762_e("inventorySide")];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("bookInventory", (NBTBase)this.bookInventory.serializeNBT());
        tag.func_74782_a("resourceInventory", (NBTBase)this.resourceInventory.serializeNBT());
        tag.func_74757_a("useAdjacentInventory", this.useAdjacentInventory);
        tag.func_74780_a("storedEnergy", this.storedEnergy);
        tag.func_74768_a(ORIENTATION_TAG, this.orientation.ordinal());
        tag.func_74768_a("inventoryDirection", this.inventoryDirection.ordinal());
        tag.func_74768_a("inventorySide", this.inventorySide.ordinal());
        return tag;
    }

    @Override
    public boolean hasWork() {
        return this.storedEnergy < this.maxEnergyStored;
    }

    private void workTick(String name, String goal, int tickCount) {
        ResearchGoal g1 = ResearchRegistry.getResearch(goal);
        int progress = ResearchTracker.INSTANCE.getProgress(this.field_145850_b, name);
        if ((progress += tickCount) >= g1.getTotalResearchTime()) {
            ResearchTracker.INSTANCE.finishResearch(this.field_145850_b, this.getCrafterName(), goal);
            this.tryStartNextResearch(name);
        } else {
            ResearchTracker.INSTANCE.setProgress(this.field_145850_b, name, progress);
        }
        this.storedEnergy -= AWCoreStatics.energyPerResearchUnit;
    }

    private void tryStartNextResearch(String name) {
        List<String> queue = ResearchTracker.INSTANCE.getResearchQueueFor(this.field_145850_b, name);
        if (!queue.isEmpty()) {
            String goalName = queue.get(0);
            ResearchGoal goalInstance = ResearchRegistry.getResearch(goalName);
            if (goalInstance == null) {
                return;
            }
            if (goalInstance.tryStart((IItemHandler)this.resourceInventory)) {
                ResearchTracker.INSTANCE.startResearch(this.field_145850_b, name, goalName);
            } else if (this.useAdjacentInventory) {
                boolean started = WorldTools.getItemHandlerFromTile((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(this.inventoryDirection), this.inventorySide).map(goalInstance::tryStart).orElse(false);
                if (started) {
                    ResearchTracker.INSTANCE.startResearch(this.field_145850_b, name, goalName);
                }
            }
        }
        this.startCheckDelay = this.startCheckDelayMax;
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.RESEARCH;
    }

    @Override
    public final Team getTeam() {
        return this.field_145850_b.func_96441_U().func_96509_i(this.getOwner().getName());
    }

    @Override
    public void addEnergyFromWorker(IWorker worker) {
        this.storedEnergy += AWCoreStatics.energyPerWorkUnit * (double)worker.getWorkEffectiveness(this.getWorkType());
        if (this.storedEnergy > this.getMaxTorque(null)) {
            this.storedEnergy = this.getMaxTorque(null);
        }
    }

    @Override
    public void addEnergyFromPlayer(EntityPlayer player) {
        this.storedEnergy += AWCoreStatics.energyPerWorkUnit;
        if (this.storedEnergy > this.getMaxTorque(null)) {
            this.storedEnergy = this.getMaxTorque(null);
        }
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 12, this.field_174879_c);
        }
        return true;
    }

    @Override
    public EnumFacing getPrimaryFacing() {
        return this.orientation;
    }

    @Override
    public void setPrimaryFacing(EnumFacing face) {
        this.orientation = face;
    }

    @Override
    public double drainTorque(EnumFacing from, double energy) {
        return 0.0;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.resourceInventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        super.shouldRefresh(world, pos, oldState, newSate);
        return !(newSate.func_177230_c() instanceof BlockResearchStation);
    }
}

