/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;

public class PacketHelper {
    private PacketHelper() {
    }

    public static void writeNBTTag(ByteBuf data, NBTTagCompound tag) {
        try (ByteBufOutputStream outputStream = new ByteBufOutputStream(data);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)outputStream);
        }
        catch (IOException e) {
            AncientWarfareCore.LOG.error("Error writing tag to buffer:\n", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NBTTagCompound readNBTTag(ByteBuf data) {
        try (ByteBufInputStream inputStream = new ByteBufInputStream(data);){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            return nBTTagCompound;
        }
        catch (IOException e) {
            AncientWarfareStructure.LOG.error("Error reading tag from buffer:\n", (Throwable)e);
            return new NBTTagCompound();
        }
    }
}

