/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.shadowmage.ancientwarfare.core.util.MathUtils;

public class Trig {
    public static final float PI = (float)Math.PI;
    public static final float TORADIANS = (float)Math.PI / 180;
    private static final float TODEGREES = 57.295776f;
    private static final float GRAVITY = 9.81f;

    private Trig() {
    }

    public static float toRadians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static float toDegrees(float radians) {
        return radians * 57.295776f;
    }

    public static float cosDegrees(float degrees) {
        return MathHelper.func_76134_b((float)(degrees * ((float)Math.PI / 180)));
    }

    public static float sinDegrees(float degrees) {
        return MathHelper.func_76126_a((float)(degrees * ((float)Math.PI / 180)));
    }

    public static float cos(float radians) {
        return MathHelper.func_76134_b((float)radians);
    }

    public static float sin(float radians) {
        return MathHelper.func_76126_a((float)radians);
    }

    public static float getVelocity(double x, double y, double z) {
        return MathHelper.func_76133_a((double)(x * x + y * y + z * z));
    }

    public static float getDistance(double x, double y, double z, double x1, double y1, double z1) {
        return Math.abs(Trig.getVelocity(x1 - x, y1 - y, z1 - z));
    }

    public static float getAngleDiffSigned(float alpha, float beta) {
        float phi = Math.abs(beta - alpha) % 360.0f;
        float diff = Trig.wrapTo360(beta) - Trig.wrapTo360(alpha);
        int sign = diff >= 0.0f && diff <= 180.0f || diff <= -180.0f && diff >= -360.0f ? 1 : -1;
        return (float)sign * (phi > 180.0f ? 360.0f - phi : phi);
    }

    public static double min(double ... vals) {
        double min = vals[0];
        for (int i = 1; i < vals.length; ++i) {
            if (!(vals[i] < min)) continue;
            min = vals[i];
        }
        return min;
    }

    public static double max(double ... vals) {
        double max = vals[0];
        for (int i = 1; i < vals.length; ++i) {
            if (!(vals[i] > max)) continue;
            max = vals[i];
        }
        return max;
    }

    public static float min(float ... vals) {
        float min = Float.MAX_VALUE;
        for (float val : vals) {
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static float max(float ... vals) {
        float max = Float.MIN_VALUE;
        for (float val : vals) {
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static float wrapTo360(float angle) {
        float f;
        return f >= 0.0f ? angle : (angle %= 360.0f) + 360.0f;
    }

    public static Tuple<Float, Float> getLaunchAngleToHit(float x, float y, float v) {
        float v2 = v * v;
        float v4 = v * v * v * v;
        float x2 = x * x;
        float sqRtVal = MathHelper.func_76129_c((float)(v4 - 9.81f * (9.81f * x2 + 2.0f * y * v2)));
        float h = v2 + sqRtVal;
        float l = v2 - sqRtVal;
        h /= 9.81f * x;
        l /= 9.81f * x;
        h = Trig.wrapTo360(Trig.toDegrees((float)Math.atan(h)));
        l = Trig.wrapTo360(Trig.toDegrees((float)Math.atan(l)));
        return new Tuple((Object)Float.valueOf(h), (Object)Float.valueOf(l));
    }

    public static Tuple<Float, Float> getLaunchAngleToHit(float x, float y, float z, float v) {
        return Trig.getLaunchAngleToHit(MathHelper.func_76129_c((float)(x * x + z * z)), y, v);
    }

    public static float iterativeSpeedFinder(float x, float y, float z, float angle, int maxIterations, boolean rocket) {
        return Trig.bruteForceSpeedFinder(MathHelper.func_76129_c((float)(x * x + z * z)), y, angle, maxIterations, rocket);
    }

    private static float bruteForceRocketFinder(float x, float y, float angle, int maxIterations) {
        float bestVelocity = 0.0f;
        float velocityIncrement = 5.29f;
        float testVelocity = 1.0f;
        float gravityTick = 0.024525002f;
        float hitX = 0.0f;
        boolean hitGround = true;
        for (int iter = 0; iter < maxIterations; ++iter) {
            hitGround = true;
            float posX = 0.0f;
            float posY = 0.0f;
            float motX = Trig.sinDegrees(angle) * testVelocity * 0.05f;
            float motY = Trig.cosDegrees(angle) * testVelocity * 0.05f;
            int rocketBurnTime = (int)(testVelocity * 3.0f);
            float motX0 = motX / (testVelocity * 0.05f) * 0.01f;
            float motY0 = motY / (testVelocity * 0.05f) * 0.01f;
            motX = motX0;
            motY = motY0;
            while (motY >= 0.0f || posY >= y) {
                posX += motX;
                posY += motY;
                if (rocketBurnTime > 0) {
                    --rocketBurnTime;
                    motX += motX0;
                    motY += motY0;
                } else {
                    motY -= gravityTick;
                }
                if (!(posX > x)) continue;
                hitGround = false;
                break;
            }
            if (hitGround) {
                float hitDiffX = motX - posX;
                float hitDiffY = (motY += gravityTick) - posY;
                float hitPercent = (y - posY) / hitDiffY;
                hitX = posX + hitDiffX * hitPercent;
            }
            if (hitGround && hitX < x || posX < x) {
                bestVelocity = testVelocity;
                testVelocity += velocityIncrement;
                continue;
            }
            bestVelocity = testVelocity;
            testVelocity -= velocityIncrement;
            testVelocity += (velocityIncrement *= 0.5f);
        }
        return bestVelocity;
    }

    private static float bruteForceSpeedFinder(float x, float y, float angle, int maxIterations, boolean rocket) {
        angle = 90.0f - angle;
        if (rocket) {
            return Trig.bruteForceRocketFinder(x, y, angle, maxIterations);
        }
        float bestVelocity = 0.0f;
        float velocityIncrement = 10.0f;
        float testVelocity = 10.0f;
        float gravityTick = 0.024525002f;
        float hitX = 0.0f;
        for (int iter = 0; iter < maxIterations; ++iter) {
            boolean hitGround = true;
            float posX = 0.0f;
            float posY = 0.0f;
            float motX = Trig.sinDegrees(angle) * testVelocity * 0.05f;
            for (float motY = Trig.cosDegrees(angle) * testVelocity * 0.05f; motY >= 0.0f || posY >= y; posY += motY, motY -= gravityTick) {
                posX += motX;
                if (!(posX > x)) continue;
                hitGround = false;
                break;
            }
            if (hitGround) {
                float hitDiffX = motX - posX;
                float hitDiffY = (motY += gravityTick) - posY;
                float hitPercent = (y - posY) / hitDiffY;
                hitX = posX + hitDiffX * hitPercent;
            }
            if (hitGround && hitX < x) {
                bestVelocity = testVelocity;
                testVelocity += velocityIncrement;
                continue;
            }
            bestVelocity = testVelocity -= velocityIncrement;
            testVelocity += (velocityIncrement *= 0.5f);
        }
        return bestVelocity;
    }

    public static boolean isAngleBetween(float test, float min, float max) {
        test = Trig.wrapTo360(test);
        if ((min = Trig.wrapTo360(min)) < (max = Trig.wrapTo360(max))) {
            return test >= min && test <= max;
        }
        return test >= min || test <= max;
    }

    public static boolean anglesEqual(float angle1, float angle2) {
        return MathUtils.epsilonEquals(Trig.wrapTo360(angle1), Trig.wrapTo360(angle2));
    }

    public static float getYawTowardsTarget(double xStart, double zStart, double x, double z, float originYaw) {
        float yawDiff;
        float vehYaw;
        float xAO = (float)(xStart - x);
        float zAO = (float)(zStart - z);
        float yaw = Trig.toDegrees((float)Math.atan2(xAO, zAO));
        for (vehYaw = originYaw; vehYaw < 0.0f; vehYaw += 360.0f) {
        }
        while (vehYaw >= 360.0f) {
            vehYaw -= 360.0f;
        }
        for (yawDiff = yaw - vehYaw; yawDiff < -180.0f; yawDiff += 360.0f) {
        }
        while (yawDiff >= 180.0f) {
            yawDiff -= 360.0f;
        }
        return yawDiff;
    }
}

