/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.core.util.BlockTools;

public class Zone
implements INBTSerializable<NBTTagCompound> {
    public BlockPos min;
    public BlockPos max;

    public Zone(BlockPos p1, BlockPos p2) {
        this.min = BlockTools.getMin(p1, p2);
        this.max = BlockTools.getMax(p1, p2);
    }

    public Zone() {
    }

    private boolean intersects(BlockPos min, BlockPos max) {
        return this.intersects(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
    }

    public boolean intersects(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return this.max.func_177958_n() >= minX && this.max.func_177956_o() >= minY && this.max.func_177952_p() >= minZ && this.min.func_177958_n() <= maxX && this.min.func_177956_o() <= maxY && this.min.func_177952_p() <= maxZ;
    }

    public boolean intersects(Zone z) {
        return this.intersects(z.min, z.max);
    }

    public boolean equals(BlockPos min, BlockPos max) {
        return min.equals((Object)this.min) && max.equals((Object)this.max);
    }

    public boolean equals(Object object) {
        return object instanceof Zone && this.equals(((Zone)object).min, ((Zone)object).max);
    }

    public int hashCode() {
        return 31 * this.min.hashCode() + this.max.hashCode();
    }

    public String toString() {
        return String.format("From %s to %s", this.min, this.max);
    }

    public boolean contains(BlockPos pos) {
        return pos.func_177958_n() >= this.min.func_177958_n() && pos.func_177958_n() <= this.max.func_177958_n() && pos.func_177956_o() >= this.min.func_177956_o() && pos.func_177956_o() <= this.max.func_177956_o() && pos.func_177952_p() >= this.min.func_177952_p() && pos.func_177952_p() <= this.max.func_177952_p();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("min", this.min.func_177986_g());
        tag.func_74772_a("max", this.max.func_177986_g());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.min = BlockPos.func_177969_a((long)tag.func_74763_f("min"));
        this.max = BlockPos.func_177969_a((long)tag.func_74763_f("max"));
    }
}

