/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public abstract class NpcAIAttack<T extends NpcBase>
extends NpcAI<T> {
    private EntityLivingBase target;
    private int attackDelay = 0;

    public NpcAIAttack(T npc) {
        super(npc);
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a() && this.hasTargetInRange();
    }

    private boolean hasTargetInRange() {
        if (this.target == null) {
            return this.getAttackTarget().isPresent() && this.getAttackTarget().map(EntityLivingBase::func_70089_S).orElse(false) != false && this.isTargetInRange();
        }
        return this.target.func_70089_S() && this.getAttackTarget().map(t -> t.equals((Object)this.target)).orElse(false) != false && this.isTargetInRange();
    }

    private boolean isTargetInRange() {
        return this.getAttackTarget().map(t -> (double)this.npc.func_70032_d((Entity)t) < this.getAdjustedTargetDistance()).orElse(false);
    }

    private Optional<EntityLivingBase> getAttackTarget() {
        return this.npc.func_70638_az() != null ? Optional.of(this.npc.func_70638_az()) : Optional.ofNullable(this.npc.func_70643_av());
    }

    public final void func_75249_e() {
        this.target = this.getAttackTarget().orElse(null);
        this.moveRetryDelay = 0;
        this.npc.addAITask(1);
        this.npc.setSwingingArms(true);
        this.attackDelay = 0;
    }

    public final void func_75251_c() {
        this.target = null;
        this.moveRetryDelay = 0;
        this.npc.removeAITask(513);
        this.npc.setSwingingArms(false);
    }

    protected int getCoolDown() {
        return this.attackDelay;
    }

    public final void func_75246_d() {
        this.npc.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        double distanceToEntitySq = this.npc.func_70092_e(this.target.field_70165_t, this.target.func_174813_aQ().field_72338_b, this.target.field_70161_v);
        if (this.shouldCloseOnTarget(distanceToEntitySq)) {
            this.npc.addAITask(512);
            this.moveToEntity((Entity)this.target, distanceToEntitySq);
        } else {
            this.npc.func_70661_as().func_75499_g();
            --this.attackDelay;
            this.doAttack(distanceToEntitySq);
        }
    }

    private double getAdjustedTargetDistance() {
        if (this.npc.getFollowingEntity() != null) {
            return Math.max(this.getTargetDistance() / this.getDistanceToFollowingEntity(), 3.0);
        }
        return Math.max(this.getTargetDistance() / (this.getHomeDistance() / 20.0), 3.0);
    }

    private double getDistanceToFollowingEntity() {
        return Math.sqrt(this.npc.func_174818_b(this.npc.getFollowingEntity().func_180425_c()));
    }

    private double getHomeDistance() {
        return Math.sqrt(this.npc.func_174818_b(this.npc.func_180486_cf()));
    }

    private double getTargetDistance() {
        IAttributeInstance iattributeinstance = this.npc.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 35.0 : iattributeinstance.func_111126_e();
    }

    protected abstract boolean shouldCloseOnTarget(double var1);

    protected abstract void doAttack(double var1);

    public final EntityLivingBase getTarget() {
        return this.target;
    }

    public final void setAttackDelay(int value) {
        this.attackDelay = value;
    }

    public final int getAttackDelay() {
        return this.attackDelay;
    }
}

