/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.shadowmage.ancientwarfare.core.interfaces.ISinger;
import net.shadowmage.ancientwarfare.core.util.SongPlayData;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAISing
extends NpcAI<NpcBase> {
    private static final int PLAYER_DELAY = 10;
    private static final int PLAYER_RANGE = 20;
    private boolean playing = false;
    private int currentDelay;
    private int tuneIndex = -1;
    private int playerCheckDelay;
    private int playTime;
    private int maxPlayTime;
    private final ISinger bard;

    public NpcAISing(NpcBase npc) {
        super(npc);
        this.bard = (ISinger)((Object)npc);
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a() && this.bard.getSongs().size() > 0;
    }

    public void func_75249_e() {
    }

    public void func_75246_d() {
        SongPlayData data = this.bard.getSongs();
        if (this.playing) {
            ++this.playTime;
            if (this.playTime >= this.maxPlayTime) {
                this.playTime = 0;
                this.playing = false;
                int d = data.getMaxDelay() - data.getMinDelay();
                this.currentDelay = data.getMinDelay() + (d > 0 ? this.npc.func_70681_au().nextInt(d) : 0);
            }
        } else if (this.currentDelay > 0) {
            --this.currentDelay;
        } else if (data.getPlayOnPlayerEntry()) {
            --this.playerCheckDelay;
            if (this.playerCheckDelay <= 0) {
                this.playerCheckDelay = 10;
                AxisAlignedBB aabb = this.npc.func_174813_aQ().func_72321_a(20.0, 20.0, 20.0);
                List list = this.npc.field_70170_p.func_72872_a(EntityPlayer.class, aabb);
                if (!list.isEmpty()) {
                    this.setNextSong(data);
                }
            }
        } else {
            this.setNextSong(data);
        }
    }

    private void setNextSong(SongPlayData data) {
        if (data.getIsRandom()) {
            this.tuneIndex = this.npc.func_70681_au().nextInt(data.size());
        } else {
            ++this.tuneIndex;
            if (this.tuneIndex >= data.size()) {
                this.tuneIndex = 0;
            }
        }
        SongPlayData.SongEntry entry = data.get(this.tuneIndex);
        this.maxPlayTime = (int)(entry.length() * 20.0f);
        float volume = (float)entry.volume() * 0.03f;
        entry.getSound().ifPresent(s -> this.npc.field_70170_p.func_184148_a(null, this.npc.field_70165_t, this.npc.field_70163_u, this.npc.field_70161_v, s, SoundCategory.NEUTRAL, volume, 1.0f));
        this.playing = true;
        this.playTime = 0;
    }
}

