/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.npc.ai.NpcWalkNodeProcessor;

public class NpcNavigator
extends PathNavigateGround {
    private final EntityLiving entity;
    private final WalkNodeProcessor nodeProcessor = new NpcWalkNodeProcessor();

    public NpcNavigator(EntityLiving living) {
        super(living, living.field_70170_p);
        this.entity = living;
    }

    public void func_179693_d(boolean value) {
        super.func_179693_d(value);
        this.nodeProcessor.func_186316_c(value);
    }

    public void func_179691_c(boolean value) {
        super.func_179691_c(value);
        this.nodeProcessor.func_186317_a(value);
    }

    public void onWorldChange() {
        this.field_75513_b = this.entity.field_70170_p;
    }

    @Nullable
    public Path func_179680_a(BlockPos pos) {
        return !this.func_75485_k() ? null : this.pathToXYZ(pos);
    }

    @Nullable
    public Path func_75494_a(Entity target) {
        return !this.func_75485_k() ? null : this.pathToEntity(target);
    }

    public boolean func_75484_a(@Nullable Path path, double speed) {
        if (this.hasMount()) {
            ((EntityLiving)this.entity.func_184187_bx()).func_70661_as().func_75484_a(path, speed);
        }
        return super.func_75484_a(path, speed);
    }

    public void func_75499_g() {
        if (this.hasMount()) {
            ((EntityLiving)this.entity.func_184187_bx()).func_70661_as().func_75499_g();
        }
        super.func_75499_g();
    }

    public void func_75501_e() {
        super.func_75501_e();
        if (!this.func_75500_f() && this.hasMount()) {
            ((EntityLiving)this.entity.func_184187_bx()).func_70661_as().func_75501_e();
        }
    }

    private boolean hasMount() {
        return this.entity.func_184187_bx() instanceof EntityLiving;
    }

    private EntityLiving mountOrEntity() {
        return this.hasMount() ? (EntityLiving)this.entity.func_184187_bx() : this.entity;
    }

    @Nullable
    private Path pathToEntity(Entity target) {
        ChunkCache chunkcache = this.cachePath(1, 16);
        Path pathentity = new PathFinder((NodeProcessor)this.nodeProcessor).func_186333_a((IBlockAccess)chunkcache, this.mountOrEntity(), target, this.func_111269_d());
        this.field_75513_b.field_72984_F.func_76319_b();
        return pathentity;
    }

    @Nullable
    private Path pathToXYZ(BlockPos pos) {
        ChunkCache chunkcache = this.cachePath(0, 8);
        Path pathentity = new PathFinder((NodeProcessor)this.nodeProcessor).func_186336_a((IBlockAccess)chunkcache, this.mountOrEntity(), pos, this.func_111269_d());
        this.field_75513_b.field_72984_F.func_76319_b();
        return pathentity;
    }

    private ChunkCache cachePath(int h, int r) {
        this.field_75513_b.field_72984_F.func_76320_a("pathfind");
        int i = MathHelper.func_76128_c((double)this.entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)(this.entity.field_70163_u + (double)h));
        int k = MathHelper.func_76128_c((double)this.entity.field_70161_v);
        int l = (int)(this.func_111269_d() + (float)r);
        return new ChunkCache(this.field_75513_b, new BlockPos(i - l, j - l, k - l), new BlockPos(i + l, j + l, k + l), 0);
    }

    protected boolean func_75485_k() {
        return super.func_75485_k() || this.hasMount();
    }

    protected boolean func_179683_a(int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize, Vec3d origin, double vecX, double vecZ) {
        int k1 = xOffset - xSize / 2;
        int l1 = zOffset - zSize / 2;
        if (!this.func_179692_b(k1, yOffset, l1, xSize, ySize, zSize, origin, vecX, vecZ)) {
            return false;
        }
        for (int i2 = k1; i2 < k1 + xSize; ++i2) {
            for (int j2 = l1; j2 < l1 + zSize; ++j2) {
                double d2 = (double)i2 + 0.5 - origin.field_72450_a;
                double d3 = (double)j2 + 0.5 - origin.field_72449_c;
                if (!(d2 * vecX + d3 * vecZ >= 0.0)) continue;
                Material material = this.field_75513_b.func_180495_p(new BlockPos(i2, yOffset - 1, j2)).func_185904_a();
                if (material == Material.field_151579_a || material == Material.field_151587_i || material == Material.field_151581_o || material == Material.field_151570_A) {
                    return false;
                }
                if (material != Material.field_151586_h || this.entity.func_70090_H()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        String result = this.func_75500_f() ? "No Path " + (this.func_75505_d() != null ? Integer.valueOf(this.func_75505_d().func_75874_d()) : "") : "Path to " + this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e()).toString();
        if (this.hasMount() && !((EntityLiving)this.entity.func_184187_bx()).func_70661_as().func_75500_f()) {
            Path path = ((EntityLiving)this.entity.func_184187_bx()).func_70661_as().func_75505_d();
            result = result + "AND Mount path to " + path.func_75877_a(path.func_75873_e()).toString();
        }
        return result;
    }
}

