/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.faction;

import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.EnumHand;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttack;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIFactionRangedAttack
extends NpcAIAttack<NpcBase> {
    private final IRangedAttackMob rangedAttacker;
    private int attackDistanceSq;
    private final int rangedAttackDelay;

    public <T extends NpcBase> NpcAIFactionRangedAttack(T npc, double moveSpeed, int attackDistanceSq, int attackDelay) {
        super(npc);
        this.rangedAttacker = (IRangedAttackMob)npc;
        this.moveSpeed = moveSpeed;
        this.attackDistanceSq = attackDistanceSq;
        this.rangedAttackDelay = attackDelay;
    }

    public <T extends NpcBase> NpcAIFactionRangedAttack(T npc) {
        this(npc, 1.0, (int)Math.pow(npc.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), 2.0), 45);
    }

    @Override
    protected boolean shouldCloseOnTarget(double dist) {
        return dist > this.getAttackDistanceSq() || !this.npc.func_70635_at().func_75522_a((Entity)this.getTarget());
    }

    private double getAttackDistanceSq() {
        if (this.attackDistanceSq == -1) {
            double distance = this.npc.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
            this.attackDistanceSq = (int)(distance * distance);
        }
        return this.attackDistanceSq;
    }

    @Override
    protected void doAttack(double dist) {
        if (!this.npc.func_184587_cr()) {
            this.npc.func_184598_c(EnumHand.MAIN_HAND);
        } else if (this.getAttackDelay() <= 0) {
            this.npc.func_184602_cy();
            float pwr = (float)(this.getAttackDistanceSq() / dist);
            pwr = Math.min(Math.max(pwr, 0.1f), 1.0f);
            this.rangedAttacker.func_82196_d(this.getTarget(), pwr);
            this.setAttackDelay(this.rangedAttackDelay);
        }
    }
}

