/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcWorker;

public class NpcAIPlayerOwnedFindWorksite
extends NpcAI<NpcWorker> {
    private int lastExecuted = -1;
    private static final int CHECK_FREQUENCY = 200;
    private static final int RANGE = 40;

    public NpcAIPlayerOwnedFindWorksite(NpcWorker npc) {
        super(npc);
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        return (this.lastExecuted == -1 || ((NpcWorker)this.npc).field_70173_aa - this.lastExecuted > 200) && ((NpcWorker)this.npc).ordersStack.func_190926_b() && ((NpcWorker)this.npc).autoWorkTarget == null;
    }

    public void func_75249_e() {
        this.lastExecuted = ((NpcWorker)this.npc).field_70173_aa;
        if (((NpcWorker)this.npc).autoWorkTarget != null) {
            BlockPos pos = ((NpcWorker)this.npc).autoWorkTarget;
            Optional<IWorkSite> te = WorldTools.getTile((IBlockAccess)((NpcWorker)this.npc).field_70170_p, pos, IWorkSite.class);
            if (te.isPresent()) {
                IWorkSite site = te.get();
                if (!((NpcWorker)this.npc).canWorkAt(site.getWorkType()) || ((NpcWorker)this.npc).hasCommandPermissions(site.getOwner()) || !site.hasWork()) {
                    ((NpcWorker)this.npc).autoWorkTarget = null;
                }
            } else {
                ((NpcWorker)this.npc).autoWorkTarget = null;
            }
        }
        if (((NpcWorker)this.npc).autoWorkTarget == null) {
            this.findWorkTarget();
        }
    }

    private void findWorkTarget() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)((NpcWorker)this.npc).field_70165_t);
        List<TileEntity> tiles = WorldTools.getTileEntitiesInArea(((NpcWorker)this.npc).field_70170_p, x - 40, (y = MathHelper.func_76128_c((double)((NpcWorker)this.npc).field_70163_u)) - 20, (z = MathHelper.func_76128_c((double)((NpcWorker)this.npc).field_70161_v)) - 40, x + 40, y + 20, z + 40);
        if (tiles.isEmpty()) {
            return;
        }
        ((NpcWorker)this.npc).autoWorkTarget = this.getClosestWorksitePos(tiles);
    }

    @Nullable
    private BlockPos getClosestWorksitePos(List<TileEntity> tiles) {
        BlockPos closestPos = null;
        double closestDist = -1.0;
        for (TileEntity te : tiles) {
            IWorkSite site;
            if (!(te instanceof IWorkSite) || (site = (IWorkSite)te).getOwner() != Owner.EMPTY && !((NpcWorker)this.npc).hasCommandPermissions(site.getOwner()) || !((NpcWorker)this.npc).canWorkAt(site.getWorkType()) || !site.hasWork()) continue;
            double dist = ((NpcWorker)this.npc).func_70092_e((double)te.func_174877_v().func_177958_n() + 0.5, te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p() + 0.5);
            if (closestDist != -1.0 && !(dist < closestDist)) continue;
            closestDist = dist;
            closestPos = te.func_174877_v();
        }
        return closestPos;
    }
}

