/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.item.ItemNpcSpawner;
import net.shadowmage.ancientwarfare.npc.tile.TileTownHall;

public class NpcAIPlayerOwnedPriest
extends NpcAI<NpcPlayerOwned> {
    private static final int UPDATE_FREQ = 200;
    private static final int RESURRECTION_TIME = 100;
    private int lastCheckTicks = -1;
    private TileTownHall.NpcDeathEntry entryToRes;
    private int resurrectionDelay = 0;

    public NpcAIPlayerOwnedPriest(NpcPlayerOwned npc) {
        super(npc);
        this.func_75248_a(3);
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.entryToRes == null) {
            return (this.lastCheckTicks == -1 || ((NpcPlayerOwned)this.npc).field_70173_aa - this.lastCheckTicks > 200) && ((NpcPlayerOwned)this.npc).getTownHall().map(t -> !t.getDeathList().isEmpty()).orElse(false) != false;
        }
        return ((NpcPlayerOwned)this.npc).getTownHall().isPresent() && !this.entryToRes.resurrected && this.entryToRes.beingResurrected;
    }

    public void func_75249_e() {
        this.lastCheckTicks = ((NpcPlayerOwned)this.npc).field_70173_aa;
        List list = ((NpcPlayerOwned)this.npc).getTownHall().map(TileTownHall::getDeathList).orElse(Collections.emptyList());
        for (TileTownHall.NpcDeathEntry entry : list) {
            if (!entry.canRes || entry.resurrected || entry.beingResurrected) continue;
            this.entryToRes = entry;
            entry.beingResurrected = true;
            break;
        }
    }

    public void func_75246_d() {
        if (this.entryToRes == null || this.entryToRes.resurrected) {
            return;
        }
        Optional<BlockPos> townHallPos = ((NpcPlayerOwned)this.npc).getTownHallPosition();
        if (!townHallPos.isPresent()) {
            return;
        }
        BlockPos pos = townHallPos.get();
        double dist = ((NpcPlayerOwned)this.npc).func_70092_e((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        if (dist > (double)(AWNPCStatics.npcActionRange * AWNPCStatics.npcActionRange)) {
            this.moveToPosition(pos, dist);
            this.resurrectionDelay = 0;
        } else {
            ++this.resurrectionDelay;
            ((NpcPlayerOwned)this.npc).func_184609_a(EnumHand.MAIN_HAND);
            if (this.resurrectionDelay > 100) {
                this.resurrectionDelay = 0;
                this.resurrectTarget();
            }
        }
    }

    private void resurrectTarget() {
        NpcBase resdNpc = ItemNpcSpawner.createNpcFromItem(((NpcPlayerOwned)this.npc).field_70170_p, this.entryToRes.stackToSpawn);
        this.entryToRes.beingResurrected = false;
        if (resdNpc != null) {
            if (!AWNPCStatics.persistOrdersOnDeath) {
                resdNpc.ordersStack = ItemStack.field_190927_a;
                resdNpc.upkeepStack = ItemStack.field_190927_a;
            }
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                resdNpc.func_184201_a(slot, ItemStack.field_190927_a);
            }
            resdNpc.setShieldStack(ItemStack.field_190927_a);
            resdNpc.setOwner(((NpcPlayerOwned)this.npc).getOwner());
            resdNpc.func_70606_j(resdNpc.func_110138_aP() / 2.0f);
            resdNpc.func_70080_a(((NpcPlayerOwned)this.npc).field_70165_t, ((NpcPlayerOwned)this.npc).field_70163_u, ((NpcPlayerOwned)this.npc).field_70161_v, ((NpcPlayerOwned)this.npc).field_70177_z, ((NpcPlayerOwned)this.npc).field_70125_A);
            resdNpc.func_70653_a((Entity)this.npc, 0.0f, 2.0 * ((NpcPlayerOwned)this.npc).func_70681_au().nextDouble() - 1.0, 2.0 * ((NpcPlayerOwned)this.npc).func_70681_au().nextDouble() - 1.0);
            resdNpc.field_70181_x = 0.0;
            this.entryToRes.resurrected = ((NpcPlayerOwned)this.npc).field_70170_p.func_72838_d((Entity)resdNpc);
        }
        ((NpcPlayerOwned)this.npc).getTownHall().ifPresent(TileTownHall::informViewers);
        this.entryToRes = null;
    }

    public void func_75251_c() {
        if (this.entryToRes != null && !this.entryToRes.resurrected) {
            this.entryToRes.beingResurrected = false;
        }
        this.entryToRes = null;
    }
}

