/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcWorker;

public class NpcAIPlayerOwnedWorkRandom
extends NpcAI<NpcWorker> {
    private int ticksAtSite = 0;

    public NpcAIPlayerOwnedWorkRandom(NpcWorker npc) {
        super(npc);
        this.func_75248_a(3);
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (((NpcWorker)this.npc).getFoodRemaining() <= 0 || ((NpcWorker)this.npc).shouldBeAtHome()) {
            return false;
        }
        return ((NpcWorker)this.npc).ordersStack.func_190926_b() && ((NpcWorker)this.npc).autoWorkTarget != null;
    }

    public void func_75249_e() {
        ((NpcWorker)this.npc).addAITask(16);
        this.ticksAtSite = 0;
    }

    public void func_75246_d() {
        BlockPos pos = ((NpcWorker)this.npc).autoWorkTarget;
        double dist = ((NpcWorker)this.npc).func_174818_b(pos);
        if (dist > ((NpcWorker)this.npc).getWorkRangeSq()) {
            ((NpcWorker)this.npc).addAITask(512);
            this.ticksAtSite = 0;
            this.moveToPosition(pos, dist);
        } else {
            ((NpcWorker)this.npc).func_70661_as().func_75499_g();
            ((NpcWorker)this.npc).removeAITask(512);
            this.workAtSite();
        }
    }

    public void func_75251_c() {
        ((NpcWorker)this.npc).removeAITask(528);
    }

    private void workAtSite() {
        ++this.ticksAtSite;
        if (((NpcWorker)this.npc).field_70173_aa % 10 == 0) {
            ((NpcWorker)this.npc).func_184609_a(EnumHand.MAIN_HAND);
        }
        if (this.ticksAtSite >= AWNPCStatics.npcWorkTicks) {
            IWorkSite site;
            this.ticksAtSite = 0;
            Optional<IWorkSite> te = WorldTools.getTile((IBlockAccess)((NpcWorker)this.npc).field_70170_p, ((NpcWorker)this.npc).autoWorkTarget, IWorkSite.class);
            if (te.isPresent() && ((NpcWorker)this.npc).canWorkAt((site = te.get()).getWorkType()) && site.hasWork()) {
                ((NpcWorker)this.npc).addExperience(AWNPCStatics.npcXpFromWork);
                site.addEnergyFromWorker((IWorker)((Object)this.npc));
                return;
            }
            ((NpcWorker)this.npc).autoWorkTarget = null;
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.ticksAtSite = tag.func_74762_e("ticksAtSite");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("ticksAtSite", this.ticksAtSite);
        return tag;
    }
}

