/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.command;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.shadowmage.ancientwarfare.core.command.RootCommand;
import net.shadowmage.ancientwarfare.core.command.SimpleSubCommand;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.npc.gamedata.Team;
import net.shadowmage.ancientwarfare.npc.gamedata.TeamData;

public class CommandTeams
extends RootCommand {
    public CommandTeams() {
        this.registerSubCommand(new SimpleSubCommand("list", (server, sender, args) -> {
            for (Team team : AWGameData.INSTANCE.getData(sender.func_130014_f_(), TeamData.class).getTeams()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(team.getName().toString()));
            }
        }));
        this.registerSubCommand(new SimpleSubCommand("describe", (server, sender, args) -> {
            if (args.length == 0) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.func_71518_a(sender), new Object[0]));
                return;
            }
            Optional<Team> t = AWGameData.INSTANCE.getData(sender.func_130014_f_(), TeamData.class).getTeam(new ResourceLocation(args[0]));
            if (t.isPresent()) {
                Team team = t.get();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.teams.team_members", new Object[]{StringTools.joinElements(", ", team.getMembers())}));
                this.outputTeamStandings(sender, team);
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.teams.team_does_not_exist", new Object[0]));
            }
        }){

            @Override
            public int getMaxArgs() {
                return 1;
            }
        });
        this.registerSubCommand(new SimpleSubCommand("player", (server, sender, args) -> {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.teams.member_of", new Object[0]));
            String playerName = args.length == 0 ? sender.func_70005_c_() : args[0];
            for (Team team : AWGameData.INSTANCE.getData(sender.func_130014_f_(), TeamData.class).getPlayerTeams(playerName)) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.teams.team_name", new Object[]{team.getName().toString()}));
                this.outputTeamStandings(sender, team);
            }
        }){

            @Override
            public int getMaxArgs() {
                return 1;
            }
        });
    }

    private void outputTeamStandings(ICommandSender sender, Team team) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.teams.standings", new Object[0]));
        for (Map.Entry standing : StreamSupport.stream(team.getFactionStandings().spliterator(), false).sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList())) {
            sender.func_145747_a((ITextComponent)new TextComponentString((String)standing.getKey() + ": " + standing.getValue()));
        }
    }

    public String func_71517_b() {
        return "awteams";
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return "command.aw.teams.usage";
    }
}

