/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.npc.init.AWNPCItems;
import net.shadowmage.ancientwarfare.npc.orders.CombatOrder;

public class ContainerCombatOrder
extends ContainerBase {
    private boolean hasChanged;
    private EnumHand hand;
    public final CombatOrder combatOrder;

    public ContainerCombatOrder(EntityPlayer player, int x, int y, int z) {
        super(player);
        this.hand = EntityTools.getHandHoldingItem((EntityLivingBase)player, AWNPCItems.COMBAT_ORDER);
        ItemStack stack = player.func_184586_b(this.hand);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Cannot open Combat Order GUI for empty stack/item.");
        }
        this.combatOrder = CombatOrder.getCombatOrder(stack);
        if (this.combatOrder == null) {
            throw new IllegalArgumentException("Combat orders was null for some reason");
        }
        this.addPlayerSlots();
        this.removeSlots();
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("combatOrder")) {
            this.combatOrder.deserializeNBT(tag.func_74775_l("combatOrder"));
            this.hasChanged = true;
        }
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        if (this.hasChanged && !this.player.field_70170_p.field_72995_K) {
            this.combatOrder.write(this.player.func_184586_b(this.hand));
        }
    }

    public void close() {
        NBTTagCompound outer = new NBTTagCompound();
        outer.func_74782_a("combatOrder", (NBTBase)this.combatOrder.serializeNBT());
        this.sendDataToServer(outer);
    }
}

