/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import electroblob.wizardry.spell.Spell;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.text.translation.I18n;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcBase;
import net.shadowmage.ancientwarfare.npc.container.ISkinSettingsContainer;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionSpellcasterWizardry;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefaultsRegistry;
import net.shadowmage.ancientwarfare.npc.skin.NpcSkinSettings;

public class ContainerNpcFactionSpellcasterWizardry
extends ContainerNpcBase<NpcFactionSpellcasterWizardry>
implements ISkinSettingsContainer {
    private static final String SKIN_SETTINGS_TAG = "skinSettings";
    private final List<Spell> allSpells = Spell.getAllSpells();
    private List<Spell> assignedSpells;
    private int maxHealth;
    private NpcSkinSettings skinSettings = ((NpcFactionSpellcasterWizardry)this.entity).getSkinSettings();
    private boolean hasChanged;

    public ContainerNpcFactionSpellcasterWizardry(EntityPlayer player, int x, int y, int z) {
        super(player, x);
        this.maxHealth = ((NpcFactionSpellcasterWizardry)this.entity).getMaxHealthOverride();
        this.assignedSpells = ((NpcFactionSpellcasterWizardry)this.entity).getSpells();
    }

    public void sendChangesToServer() {
        this.sendDataToServer(this.serializeContainerData());
    }

    private NBTTagCompound serializeContainerData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(SKIN_SETTINGS_TAG, (NBTBase)this.skinSettings.serializeNBT());
        tag.func_74768_a("maxHealth", this.maxHealth);
        tag.func_74782_a("assignedSpells", (NBTBase)NBTHelper.getTagList(this.assignedSpells, spell -> new NBTTagInt(spell.metadata())));
        return tag;
    }

    @Override
    public void sendInitData() {
        this.sendDataToClient(this.serializeContainerData());
    }

    @Override
    public void handlePacketData(NBTTagCompound nbt) {
        this.assignedSpells = NBTHelper.getList(nbt.func_150295_c("assignedSpells", 3), tag -> Spell.byMetadata((int)((NBTTagInt)tag).func_150287_d()));
        this.maxHealth = nbt.func_74762_e("maxHealth");
        this.skinSettings = NpcSkinSettings.deserializeNBT(nbt.func_74775_l(SKIN_SETTINGS_TAG));
        ((NpcFactionSpellcasterWizardry)this.entity).setSkinSettings(this.skinSettings);
        this.hasChanged = true;
        this.refreshGui();
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        if (this.hasChanged && !this.player.field_70170_p.field_72995_K) {
            this.hasChanged = false;
            ((NpcFactionSpellcasterWizardry)this.entity).setSkinSettings(this.skinSettings.minimizeData());
            ((NpcFactionSpellcasterWizardry)this.entity).setSpells(this.assignedSpells);
            ((NpcFactionSpellcasterWizardry)this.entity).setMaxHealthOverride(this.maxHealth);
        }
        super.func_75134_a(par1EntityPlayer);
    }

    public List<Spell> getAssignedSpells() {
        return this.assignedSpells;
    }

    public void addSpell(Spell spell) {
        this.assignedSpells.add(spell);
    }

    public void removeSpell(Spell spell) {
        this.assignedSpells.remove(spell);
    }

    public List<Spell> getAllSpells() {
        return this.allSpells;
    }

    public void setNameAndPresetDefaults(String presetSubtypeName) {
        String[] spells;
        String faction = ((NpcFactionSpellcasterWizardry)this.entity).getFaction();
        String nameTag = "entity.ancientwarfarenpc." + faction + "." + presetSubtypeName + ".name";
        ((NpcFactionSpellcasterWizardry)this.entity).func_96094_a(I18n.func_74838_a((String)nameTag));
        for (String spell : spells = NpcDefaultsRegistry.getFactionNpcDefault(((NpcFactionSpellcasterWizardry)this.entity).getFaction(), presetSubtypeName).getSpells().split(",")) {
            Spell spellObj = Spell.get((String)spell);
            this.addSpell(spellObj);
        }
        this.maxHealth = (int)NpcDefaultsRegistry.getFactionNpcDefault(((NpcFactionSpellcasterWizardry)this.entity).getFaction(), presetSubtypeName).getBaseHealth();
        this.skinSettings.setSkinType(NpcSkinSettings.SkinType.NPC_TYPE);
        this.skinSettings.setRandom(true);
        this.skinSettings.setNpcTypeName(faction + "." + presetSubtypeName);
    }

    @Override
    public void handleNpcSkinUpdate() {
        this.sendDataToServer(SKIN_SETTINGS_TAG, (NBTBase)this.skinSettings.serializeNBT());
    }

    @Override
    public NpcSkinSettings getSkinSettings() {
        return this.skinSettings;
    }

    @Override
    public void setSkinSettings(NpcSkinSettings skinSettings) {
        this.skinSettings = skinSettings;
    }
}

