/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcBase;
import net.shadowmage.ancientwarfare.npc.container.ISkinSettingsContainer;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.inventory.NpcEquipmentHandler;
import net.shadowmage.ancientwarfare.npc.skin.NpcSkinSettings;

public class ContainerNpcInventory
extends ContainerNpcBase<NpcBase>
implements ISkinSettingsContainer {
    public boolean doNotPursue;
    public boolean isArcher;
    public final int guiHeight;
    private String name;
    public NpcSkinSettings skinSettings;

    public ContainerNpcInventory(EntityPlayer player, int x, int y, int z) {
        super(player, x);
        this.isArcher = ((NpcBase)this.entity).getNpcSubType().equals("archer");
        NpcEquipmentHandler inventory = new NpcEquipmentHandler((NpcBase)this.entity);
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 0, 8, 8));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 1, 8, 26));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 2, 8, 98));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 3, 8, 80));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 4, 8, 62));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 5, 8, 44));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 6, 44, 62));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, 7, 44, 44));
        this.guiHeight = this.addPlayerSlots(124) + 8;
        this.name = ((NpcBase)this.entity).func_95999_t();
        this.doNotPursue = ((NpcBase)this.entity).getDoNotPursue();
        this.skinSettings = ((NpcBase)this.entity).getSkinSettings();
    }

    public void sendChangesToServer() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("donotpursue", this.doNotPursue);
        this.sendDataToServer(tag);
    }

    @Override
    public void sendInitData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("donotpursue", this.doNotPursue);
        this.sendDataToClient(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("customName")) {
            this.name = tag.func_74779_i("customName");
        }
        if (this.entity != null && !((NpcBase)this.entity).field_70128_L) {
            if (tag.func_74764_b("repack")) {
                ((NpcBase)this.entity).repackEntity(this.player);
            } else if (tag.func_74764_b("setHome")) {
                ((NpcBase)this.entity).setHomeAreaAtCurrentPosition();
            } else if (tag.func_74764_b("clearHome")) {
                ((NpcBase)this.entity).func_110177_bN();
            } else if (tag.func_74764_b("togglefollow")) {
                if (((NpcBase)this.entity).getFollowingEntity() != null && ((NpcBase)this.entity).getFollowingEntity().func_70005_c_().equals(this.player.func_70005_c_())) {
                    ((NpcBase)this.entity).clearFollowingEntity();
                } else {
                    ((NpcBase)this.entity).setFollowingEntity((EntityLivingBase)this.player);
                }
            }
            if (tag.func_74764_b("donotpursue")) {
                this.doNotPursue = tag.func_74767_n("donotpursue");
            }
            if (tag.func_74764_b("skinSettings")) {
                this.skinSettings = NpcSkinSettings.deserializeNBT(tag.func_74775_l("skinSettings")).minimizeData();
                ((NpcBase)this.entity).setSkinSettings(this.skinSettings);
            }
        }
        this.refreshGui();
    }

    public void handleNpcNameUpdate(String newName) {
        this.name = newName;
    }

    @Override
    public void handleNpcSkinUpdate() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("skinSettings", (NBTBase)this.skinSettings.serializeNBT());
        this.sendDataToServer(tag);
    }

    public void func_75134_a(EntityPlayer p_75134_1_) {
        super.func_75134_a(p_75134_1_);
        ((NpcBase)this.entity).func_96094_a(this.name);
        ((NpcBase)this.entity).setSkinSettings(this.skinSettings);
        ((NpcBase)this.entity).setDoNotPursue(this.doNotPursue);
    }

    public void setName() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("customName", this.name);
        this.sendDataToServer(tag);
    }

    @Override
    public NpcSkinSettings getSkinSettings() {
        return this.skinSettings;
    }

    @Override
    public void setSkinSettings(NpcSkinSettings skinSettings) {
        this.skinSettings = skinSettings;
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotClickedIndex) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotClickedIndex);
        if (slot != null && slot.func_75216_d()) {
            int i;
            ItemStack slotStack = slot.func_75211_c();
            itemstack = slotStack.func_77946_l();
            EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d((ItemStack)itemstack);
            if (slotClickedIndex < 8 ? !this.func_75135_a(slotStack, 8, 44, true) : (entityequipmentslot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR && !((Slot)this.field_75151_b.get(2 + entityequipmentslot.func_188454_b())).func_75216_d() ? !this.func_75135_a(slotStack, i = 2 + entityequipmentslot.func_188454_b(), i + 1, false) : (entityequipmentslot == EntityEquipmentSlot.MAINHAND && !((Slot)this.field_75151_b.get(0)).func_75216_d() && !((Slot)this.field_75151_b.get(1)).func_75216_d() ? !this.func_75135_a(slotStack, 0, 2, false) : (entityequipmentslot == EntityEquipmentSlot.OFFHAND && !((Slot)this.field_75151_b.get(1)).func_75216_d() ? !this.func_75135_a(slotStack, 1, 2, false) : (!this.func_75139_a(6).func_75216_d() && this.func_75139_a(6).func_75214_a(slotStack) ? !this.func_75135_a(slotStack, 6, 7, false) : (!this.func_75139_a(7).func_75216_d() && this.func_75139_a(7).func_75214_a(slotStack) ? !this.func_75135_a(slotStack, 7, 8, false) : (slotClickedIndex < 17 ? !this.func_75135_a(slotStack, 17, 44, false) : (slotClickedIndex < 44 ? !this.func_75135_a(slotStack, 8, 17, false) : !this.func_75135_a(slotStack, 8, 44, false))))))))) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(player, slotStack);
            if (slotClickedIndex == 0) {
                player.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }
}

