/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.npc.init.AWNPCItems;
import net.shadowmage.ancientwarfare.npc.orders.RoutingOrder;

public class ContainerRoutingOrder
extends ContainerBase {
    private boolean hasChanged;
    private EnumHand hand;
    public final RoutingOrder routingOrder;

    public ContainerRoutingOrder(EntityPlayer player, int x, int y, int z) {
        super(player);
        this.hand = EntityTools.getHandHoldingItem((EntityLivingBase)player, AWNPCItems.ROUTING_ORDER);
        ItemStack stack = player.func_184586_b(this.hand);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Cannot open Routing Order GUI for empty stack/item.");
        }
        this.routingOrder = RoutingOrder.getRoutingOrder(stack);
        if (this.routingOrder == null) {
            throw new IllegalArgumentException("Routing orders was null for some reason");
        }
        this.addPlayerSlots(47, 156, 4);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("routingOrder")) {
            this.routingOrder.deserializeNBT(tag.func_74775_l("routingOrder"));
            this.hasChanged = true;
        }
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        if (this.hasChanged && !this.player.field_70170_p.field_72995_K) {
            this.routingOrder.write(this.player.func_184586_b(this.hand));
        }
    }

    public void onClose() {
        NBTTagCompound outer = new NBTTagCompound();
        outer.func_74782_a("routingOrder", (NBTBase)this.routingOrder.serializeNBT());
        this.sendDataToServer(outer);
    }
}

