/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.npc.init.AWNPCItems;
import net.shadowmage.ancientwarfare.npc.orders.UpkeepOrder;

public class ContainerUpkeepOrder
extends ContainerBase {
    private static final String UPKEEP_ORDER_TAG = "upkeepOrder";
    private EnumHand hand;
    public final UpkeepOrder upkeepOrder;
    public final ItemStack upkeepBlock;
    private boolean hasChanged;

    public ContainerUpkeepOrder(EntityPlayer player, int x, int y, int z) {
        super(player);
        this.hand = EntityTools.getHandHoldingItem((EntityLivingBase)player, AWNPCItems.UPKEEP_ORDER);
        ItemStack stack = player.func_184586_b(this.hand);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Cannot open Work Order GUI for null stack/item.");
        }
        Optional<UpkeepOrder> order = UpkeepOrder.getUpkeepOrder(stack);
        if (!order.isPresent()) {
            throw new IllegalArgumentException("Upkeep orders was missing for some reason");
        }
        this.upkeepOrder = order.get();
        this.upkeepBlock = this.upkeepOrder.getUpkeepPosition().map(blockPos -> new ItemStack(player.field_70170_p.func_180495_p(blockPos).func_177230_c())).orElse(ItemStack.field_190927_a);
        this.addPlayerSlots();
        this.removeSlots();
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(UPKEEP_ORDER_TAG)) {
            this.upkeepOrder.deserializeNBT(tag.func_74775_l(UPKEEP_ORDER_TAG));
            this.hasChanged = true;
        }
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        if (this.hasChanged && !this.player.field_70170_p.field_72995_K) {
            this.upkeepOrder.write(this.player.func_184586_b(this.hand));
        }
    }

    public void onClose() {
        NBTTagCompound outer = new NBTTagCompound();
        outer.func_74782_a(UPKEEP_ORDER_TAG, (NBTBase)this.upkeepOrder.serializeNBT());
        this.sendDataToServer(outer);
    }
}

