/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity.faction;

import com.google.common.primitives.Floats;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.npc.ai.AIHelper;
import net.shadowmage.ancientwarfare.npc.ai.faction.NpcAIFactionFleeSun;
import net.shadowmage.ancientwarfare.npc.ai.faction.NpcAIFactionRestrictSun;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.AdditionalAttributes;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.IAdditionalAttribute;
import net.shadowmage.ancientwarfare.npc.faction.FactionTracker;
import net.shadowmage.ancientwarfare.npc.init.AWNPCSounds;
import net.shadowmage.ancientwarfare.npc.registry.FactionNpcDefault;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefaultsRegistry;
import net.shadowmage.ancientwarfare.structure.util.CapabilityRespawnData;
import net.shadowmage.ancientwarfare.structure.util.IRespawnData;
import net.shadowmage.ancientwarfare.structure.util.SpawnerHelper;
import org.apache.commons.lang3.Range;

public abstract class NpcFaction
extends NpcBase {
    private static final int DEATH_REVENGE_TICKS = 6000;
    private static final int HIT_REVENGE_TICKS = 300;
    private static final int REVENGE_LIST_VALIDATION_TICKS = 60;
    private static final double REVENGE_SET_RANGE = 50.0;
    private static final String HEIGHT_TAG = "height";
    private static final DataParameter<String> SOUND = EntityDataManager.func_187226_a(NpcFaction.class, (DataSerializer)DataSerializers.field_187194_d);
    protected String factionName;
    private Map<String, Long> revengePlayers = new HashMap<String, Long>();
    private final Map<IAdditionalAttribute<?>, Object> additionalAttributes = new HashMap();
    private boolean canDespawn = false;

    public NpcFaction(World world) {
        super(world);
        this.addAI();
    }

    public NpcFaction(World world, String factionName) {
        super(world);
        this.setFactionNameAndDefaults(factionName);
        this.addAI();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SOUND, (Object)"none");
    }

    @Override
    protected boolean func_70692_ba() {
        return this.canDespawn;
    }

    private void setDeathRevengePlayer(String playerName) {
        this.revengePlayers.put(playerName, this.field_70170_p.func_82737_E() + 6000L);
    }

    protected void func_70623_bb() {
        IRespawnData respawnData;
        boolean deadPreDespawn = this.field_70128_L;
        super.func_70623_bb();
        if (!deadPreDespawn && this.field_70128_L && this.hasCapability(CapabilityRespawnData.RESPAWN_DATA_CAPABILITY, null) && (respawnData = (IRespawnData)this.getCapability(CapabilityRespawnData.RESPAWN_DATA_CAPABILITY, null)) != null) {
            SpawnerHelper.createSpawner(respawnData, this.field_70170_p);
        }
    }

    public void setCanDespawn() {
        this.canDespawn = true;
    }

    private void addAI() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIFactionRestrictSun(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new NpcAIFactionFleeSun(this, 1.0));
    }

    public void setAdditionalAttribute(IAdditionalAttribute<?> attribute, Object value) {
        this.additionalAttributes.put(attribute, value);
    }

    public <T> Optional<T> getAdditionalAttributeValue(IAdditionalAttribute<T> attribute) {
        return Optional.ofNullable(attribute.getValueClass().cast(this.additionalAttributes.get(attribute)));
    }

    public boolean burnsInSun() {
        return this.getAdditionalAttributeValue(AdditionalAttributes.BURNS_IN_SUN).orElse(false);
    }

    public boolean isUndead() {
        return this.getAdditionalAttributeValue(AdditionalAttributes.UNDEAD).orElse(false);
    }

    @Override
    public void func_70636_d() {
        this.doSunBurn();
        super.func_70636_d();
    }

    private void doSunBurn() {
        if (this.burnsInSun() && this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            BlockPos blockpos;
            float brightness = this.func_70013_c();
            BlockPos blockPos = blockpos = this.func_184187_bx() instanceof EntityBoat ? new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            if (brightness > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos)) {
                ItemStack helmet = this.func_184582_a(EntityEquipmentSlot.HEAD);
                if (helmet.func_190926_b()) {
                    this.func_70015_d(8);
                } else {
                    this.damageHelmet(helmet);
                }
            }
        }
    }

    private void damageHelmet(ItemStack helmet) {
        if (helmet.func_77984_f()) {
            helmet.func_77964_b(helmet.func_77952_i() + this.field_70146_Z.nextInt(2));
            if (helmet.func_77952_i() >= helmet.func_77958_k()) {
                this.func_70669_a(helmet);
                this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
            }
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        if (this.isUndead()) {
            return EnumCreatureAttribute.UNDEAD;
        }
        return EnumCreatureAttribute.UNDEFINED;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == MobEffects.field_76436_u && this.getFaction().equals("lizardman|coven")) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((EntityLivingBase)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public void setFactionNameAndDefaults(String factionName) {
        this.factionName = factionName;
        FactionNpcDefault npcDefault = NpcDefaultsRegistry.getFactionNpcDefault(this);
        this.applyFactionNpcSettings(npcDefault);
        if (!this.getCustomEquipmentOverride()) {
            npcDefault.applyEquipment(this);
        }
        if (AWNPCStatics.vanillaEquipmentDropRate) {
            this.field_184655_bs = new float[]{0.085f, 0.085f, 0.085f, 0.085f};
            this.field_82174_bp = new float[]{0.085f, 0.085f};
        } else {
            this.field_184655_bs = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            this.field_82174_bp = new float[]{1.0f, 1.0f};
        }
        Range<Float> heightRange = npcDefault.getHeightRange();
        float newHeight = ((Float)heightRange.getMinimum()).floatValue() + this.field_70170_p.field_73012_v.nextFloat() * (((Float)heightRange.getMaximum()).floatValue() - ((Float)heightRange.getMinimum()).floatValue());
        float newWidth = newHeight / 1.8f * 0.6f * npcDefault.getThinness();
        this.func_70105_a(newWidth, newHeight);
    }

    protected void func_70105_a(float width, float height) {
        super.func_70105_a(Floats.constrainToRange((float)width, (float)0.1f, (float)10.0f), Floats.constrainToRange((float)height, (float)0.1f, (float)40.0f));
    }

    private void applyFactionNpcSettings(FactionNpcDefault npcDefault) {
        npcDefault.applyAttributes(this);
        npcDefault.applyAdditionalAttributes(this);
        this.field_70728_aV = npcDefault.getExperienceDrop();
        npcDefault.applyPathSettings((PathNavigateGround)this.func_70661_as());
        String sound = this.getAdditionalAttributeValue(AdditionalAttributes.ENTITY_SOUND).isPresent() ? this.getAdditionalAttributeValue(AdditionalAttributes.ENTITY_SOUND).get() : "none";
        this.setSound(sound);
    }

    @Override
    public int func_82143_as() {
        int i = super.func_82143_as();
        if (i > 4) {
            i = (int)((float)i + (float)this.field_70170_p.func_175659_aa().func_151525_a() * this.func_110138_aP() / 5.0f);
        }
        if ((float)i >= this.func_110143_aJ()) {
            return (int)this.func_110143_aJ();
        }
        return i;
    }

    @Override
    protected boolean tryCommand(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d && super.tryCommand(player);
    }

    @Override
    public boolean hasCommandPermissions(UUID playerUuid, String playerName) {
        return false;
    }

    @Override
    public String func_70005_c_() {
        String name = I18n.func_74838_a((String)("entity.ancientwarfarenpc." + this.getNpcFullType() + ".name"));
        if (this.func_145818_k_()) {
            name = this.func_95999_t();
        }
        return name;
    }

    @Override
    protected float getLitBlockWeight(BlockPos pos) {
        return this.burnsInSun() ? 1.0f - this.field_70170_p.func_175724_o(pos) : super.getLitBlockWeight(pos);
    }

    @Override
    public String getNpcFullType() {
        return this.factionName + "." + super.getNpcFullType();
    }

    @Override
    public boolean isHostileTowards(Entity e) {
        if (e instanceof EntityPlayer || e instanceof NpcPlayerOwned) {
            String playerName = e instanceof EntityPlayer ? e.func_70005_c_() : ((NpcBase)e).getOwner().getName();
            UUID playerUUID = e instanceof EntityPlayer ? e.func_110124_au() : ((NpcBase)e).getOwner().getUUID();
            return this.revengePlayers.containsKey(playerName) || FactionTracker.INSTANCE.isHostileToPlayer(this.field_70170_p, playerUUID, playerName, this.getFaction());
        }
        if (e instanceof NpcFaction) {
            NpcFaction npc = (NpcFaction)e;
            return !npc.getFaction().equals(this.factionName) && FactionRegistry.getFaction(this.getFaction()).isHostileTowards(npc.getFaction());
        }
        return FactionRegistry.getFaction(this.factionName).isTarget(e) || AIHelper.isAdditionalEntityToTarget(e);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.func_72820_D() % 60L == 0L) {
            Iterator<Map.Entry<String, Long>> it = this.revengePlayers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Long> playerRevengeTime = it.next();
                if (this.field_70170_p.func_82737_E() <= playerRevengeTime.getValue()) continue;
                it.remove();
                this.func_70624_b(null);
                this.func_70604_c(null);
            }
        }
    }

    private String getSound() {
        return (String)this.field_70180_af.func_187225_a(SOUND);
    }

    public void setSound(String sound) {
        this.field_70180_af.func_187227_b(SOUND, (Object)sound);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.getSound().equals("none") ? SoundEvents.field_187543_bD : AWNPCSounds.getSoundEventFromString(this.getSound() + "_hurt");
    }

    protected SoundEvent func_184615_bR() {
        return this.getSound().equals("none") ? SoundEvents.field_187661_by : AWNPCSounds.getSoundEventFromString(this.getSound() + "_death");
    }

    private void playAttackSound() {
        if (!this.getSound().equals("none")) {
            this.func_184185_a(AWNPCSounds.getSoundEventFromString(this.getSound() + "_attack"), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        }
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        if (damageSrc.field_76373_n.equals("player")) {
            this.revengePlayers.put(damageSrc.func_76346_g().func_70005_c_(), this.field_70170_p.func_82737_E() + 300L);
        } else if (damageSrc.field_76373_n.equals("mob") && damageSrc.func_76346_g() instanceof NpcBase) {
            this.revengePlayers.put(((NpcBase)damageSrc.func_76346_g()).getOwner().getName(), this.field_70170_p.func_82737_E() + 300L);
        }
    }

    @Override
    public boolean canTarget(Entity e) {
        if (e instanceof NpcFaction) {
            return !((NpcFaction)e).getFaction().equals(this.getFaction());
        }
        return e instanceof EntityLivingBase;
    }

    @Override
    public boolean canBeAttackedBy(Entity e) {
        return !(e instanceof NpcFaction) || !this.getFaction().equals(((NpcFaction)e).getFaction());
    }

    @Override
    public boolean func_70652_k(Entity target) {
        if (Math.random() < 0.2) {
            this.playAttackSound();
        }
        return super.func_70652_k(target);
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (damageSource.func_76346_g() instanceof EntityPlayer || damageSource.func_76346_g() instanceof NpcPlayerOwned) {
            String playerName = damageSource.func_76346_g() instanceof EntityPlayer ? damageSource.func_76346_g().func_70005_c_() : ((NpcBase)damageSource.func_76346_g()).getOwner().getName();
            FactionTracker.INSTANCE.adjustStandingFor(this.field_70170_p, playerName, this.getFaction(), FactionRegistry.getFaction(this.getFaction()).getStandingSettings().getStandingChange("kill"));
            this.setDeathRevengePlayer(playerName);
            this.field_70170_p.func_72872_a(NpcFaction.class, new AxisAlignedBB(this.func_180425_c()).func_186662_g(50.0)).forEach(factionNpc -> {
                if (factionNpc.getFaction().equals(this.getFaction())) {
                    factionNpc.setDeathRevengePlayer(playerName);
                }
            });
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return NpcDefaultsRegistry.getFactionNpcDefault(this).getLootTable();
    }

    @Override
    public String getNpcSubType() {
        return "";
    }

    public String getFaction() {
        return this.factionName;
    }

    @Override
    public Team func_96124_cp() {
        return null;
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        new PacketBuffer(buffer).func_180714_a(this.factionName);
        buffer.writeFloat(this.field_70131_O);
        buffer.writeFloat(this.field_70130_N);
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        super.readSpawnData(buffer);
        this.factionName = new PacketBuffer(buffer).func_150789_c(20);
        this.field_70131_O = buffer.readFloat();
        this.field_70130_N = buffer.readFloat();
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.factionName = tag.func_74779_i("factionName");
        this.applyFactionNpcSettings(NpcDefaultsRegistry.getFactionNpcDefault(this));
        this.canDespawn = tag.func_74767_n("canDespawn");
        this.revengePlayers = NBTHelper.getMap(tag.func_150295_c("revengePlayers", 10), t -> t.func_74779_i("playerName"), t -> t.func_74763_f("time"));
        if (tag.func_74764_b(HEIGHT_TAG)) {
            this.func_70105_a(tag.func_74760_g("width"), tag.func_74760_g(HEIGHT_TAG));
        } else {
            this.setFactionNameAndDefaults(this.factionName);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.factionName != null) {
            tag.func_74778_a("factionName", this.factionName);
        }
        tag.func_74757_a("canDespawn", this.canDespawn);
        tag.func_74782_a("revengePlayers", (NBTBase)NBTHelper.mapToCompoundList(this.revengePlayers, (t, playerName) -> t.func_74778_a("playerName", playerName), (t, time) -> t.func_74772_a("time", time.longValue())));
        tag.func_74776_a(HEIGHT_TAG, this.field_70131_O);
        tag.func_74776_a("width", this.field_70130_N);
    }

    public float func_70603_bj() {
        return this.field_70131_O / 1.8f;
    }

    public float getWidthModifier() {
        return this.field_70130_N / 0.6f;
    }
}

