/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity.faction;

import com.google.common.base.Predicate;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttackNearest;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIDoor;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIFollowPlayer;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIMoveHome;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWander;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWatchClosest;
import net.shadowmage.ancientwarfare.npc.ai.faction.NpcAIFactionArcherStayAtHome;
import net.shadowmage.ancientwarfare.npc.ai.faction.NpcAIFactionHurt;
import net.shadowmage.ancientwarfare.npc.compat.ebwizardry.ai.EntityAIAttackSpellImproved;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;

public class NpcFactionSpellcasterWizardry
extends NpcFaction
implements ISpellCaster {
    private EntityAIAttackSpellImproved<NpcFactionSpellcasterWizardry> spellCastingAI = new EntityAIAttackSpellImproved<NpcFactionSpellcasterWizardry>(this, 0.85, 16.0f, 16, 60);
    private static final DataParameter<Integer> HEAL_COOLDOWN = EntityDataManager.func_187226_a(NpcFactionSpellcasterWizardry.class, (DataSerializer)DataSerializers.field_187192_b);
    private List<Spell> spells = new ArrayList<Spell>(4);
    private Spell continuousSpell;
    private int spellCounter;

    public NpcFactionSpellcasterWizardry(World world) {
        super(world);
        this.addAI();
        this.field_70714_bg.func_75776_a(3, this.spellCastingAI);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAL_COOLDOWN, (Object)-1);
    }

    public NpcFactionSpellcasterWizardry(World world, String factionName) {
        super(world, factionName);
        this.addAI();
        this.field_70714_bg.func_75776_a(3, this.spellCastingAI);
    }

    private void addAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new NpcAIDoor(this, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new NpcAIFollowPlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIMoveHome(this, 50.0f, 5.0f, 30.0f, 5.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIFactionArcherStayAtHome(this));
        this.field_70714_bg.func_75776_a(101, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(102, (EntityAIBase)new NpcAIWander(this));
        this.field_70714_bg.func_75776_a(103, (EntityAIBase)new NpcAIWatchClosest(this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new NpcAIFactionHurt(this, (Predicate<Entity>)((Predicate)this::isHostileTowards)));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new NpcAIAttackNearest(this, (Predicate<Entity>)((Predicate)this::isHostileTowards)));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        int healCooldown = this.getHealCooldown();
        if (healCooldown == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() > 0.0f && !this.func_70644_a(WizardryPotions.arcane_jammer)) {
            this.func_70691_i(4.0f);
            this.setHealCooldown(-1);
        } else if (healCooldown == -1 && this.field_70725_aQ == 0) {
            if (this.field_70170_p.field_72995_K) {
                this.spawnHealParticles();
            } else {
                if (this.func_110143_aJ() < 25.0f) {
                    this.setHealCooldown(150);
                } else {
                    this.setHealCooldown(400);
                }
                this.func_184185_a(Spells.heal.getSounds()[0], 0.7f, this.field_70146_Z.nextFloat() * 0.4f + 1.0f);
            }
        }
        if (healCooldown > 0) {
            this.setHealCooldown(healCooldown - 1);
        }
    }

    @Override
    public boolean isHostileTowards(Entity e) {
        return e instanceof ISummonedCreature && (((ISummonedCreature)e).func_184753_b() != this.func_110124_au() || ((ISummonedCreature)e).func_70902_q() != null && this.isHostileTowards(((ISummonedCreature)e).func_70902_q())) || super.isHostileTowards(e);
    }

    private int getHealCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(HEAL_COOLDOWN);
    }

    private void setHealCooldown(int cooldown) {
        this.field_70180_af.func_187227_b(HEAL_COOLDOWN, (Object)cooldown);
    }

    public void setSpells(List<Spell> spells) {
        this.spells = spells;
    }

    public List<Spell> getSpells() {
        return this.spells;
    }

    public void setSpellCounter(int count) {
        this.spellCounter = count;
    }

    public int getSpellCounter() {
        return this.spellCounter;
    }

    public SpellModifiers getModifiers() {
        SpellModifiers spellModifiers = new SpellModifiers();
        spellModifiers.set("potency", 1.5f, true);
        return spellModifiers;
    }

    public void setContinuousSpell(Spell spell) {
        this.continuousSpell = spell;
    }

    public Spell getContinuousSpell() {
        return this.continuousSpell;
    }

    public int getAimingError(EnumDifficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return 7;
            }
            case NORMAL: {
                return 4;
            }
            case HARD: {
                return 1;
            }
        }
        return 7;
    }

    @Override
    public boolean hasAltGui() {
        return true;
    }

    @Override
    public void openAltGui(EntityPlayer player) {
        NetworkHandler.INSTANCE.openGui(player, 62, this.func_145782_y(), 0, 0);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74782_a("spells", (NBTBase)NBTHelper.getTagList(this.getSpells(), spell -> new NBTTagString(spell.getRegistryName().toString())));
    }

    @Override
    public void writeAdditionalItemData(NBTTagCompound nbt) {
        nbt.func_74782_a("spells", (NBTBase)NBTHelper.getTagList(this.getSpells(), spell -> new NBTTagString(spell.getRegistryName().toString())));
        super.writeAdditionalItemData(nbt);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.spells = NBTHelper.getList(nbt.func_150295_c("spells", 8), tag -> Spell.get((String)((NBTTagString)tag).func_150285_a_()));
    }

    @Override
    public void readAdditionalItemData(NBTTagCompound nbt) {
        this.spells = NBTHelper.getList(nbt.func_150295_c("spells", 8), tag -> Spell.get((String)((NBTTagString)tag).func_150285_a_()));
        super.readAdditionalItemData(nbt);
    }

    @Override
    public boolean func_70686_a(Class claz) {
        return true;
    }

    @Override
    public boolean worksInRain() {
        return true;
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    @Override
    public String getNpcType() {
        return "spellcaster";
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    private void spawnHealParticles() {
        int color = FactionRegistry.getFaction(this.factionName).getColor();
        for (int i = 0; i < 10; ++i) {
            double x = this.field_70165_t + this.field_70170_p.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - 0.5 + this.field_70170_p.field_73012_v.nextDouble();
            double z = this.field_70161_v + this.field_70170_p.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(color).spawn(this.field_70170_p);
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)this).clr(color).spawn(this.field_70170_p);
    }
}

