/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.faction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;

public class FactionEntry
implements Iterable<Map.Entry<String, Integer>> {
    private final HashMap<String, Integer> factionStandings = new HashMap();

    public FactionEntry(NBTTagCompound tag) {
        this();
        this.readFromNBT(tag);
    }

    public FactionEntry() {
        for (String name : FactionRegistry.getFactionNames()) {
            this.setStandingFor(name, AncientWarfareNPC.statics.getPlayerDefaultStanding(name), false);
        }
    }

    public int getStandingFor(String factionName) {
        if (this.factionStandings.containsKey(factionName)) {
            return this.factionStandings.get(factionName);
        }
        return 0;
    }

    private void setStandingFor(String factionName, int standing, boolean checkIfFixed) {
        if (checkIfFixed && !FactionRegistry.getFaction(factionName).getStandingSettings().canPlayerStandingChange()) {
            return;
        }
        this.factionStandings.put(factionName, standing);
    }

    public void setStandingFor(String factionName, int standing) {
        this.setStandingFor(factionName, standing, true);
    }

    public void adjustStandingFor(String factionName, int adjustment) {
        if (this.factionStandings.containsKey(factionName)) {
            this.setStandingFor(factionName, this.getStandingFor(factionName) + adjustment);
        }
    }

    public final void readFromNBT(NBTTagCompound tag) {
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NBTTagCompound entryTag = entryList.func_150305_b(i);
            String name = entryTag.func_74779_i("name");
            this.setStandingFor(name, entryTag.func_74762_e("standing"));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList entryList = new NBTTagList();
        for (Map.Entry<String, Integer> entry : this.factionStandings.entrySet()) {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74778_a("name", entry.getKey());
            entryTag.func_74768_a("standing", entry.getValue().intValue());
            entryList.func_74742_a((NBTBase)entryTag);
        }
        tag.func_74782_a("entryList", (NBTBase)entryList);
        return tag;
    }

    @Override
    public Iterator<Map.Entry<String, Integer>> iterator() {
        return this.factionStandings.entrySet().iterator();
    }
}

